/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.collection.AbstractCollectionElementCondition;

public class AtLeastCollectionCondition
extends AbstractCollectionElementCondition {
    private int count;

    public AtLeastCollectionCondition(Condition elementCondition, int count) {
        super(elementCondition);
        Assert.isTrue((count >= 0 ? 1 : 0) != 0, (String)"Count cannot be negative");
        this.count = count;
    }

    protected boolean checkArray(Object array) {
        int counter = 0;
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (!this.getElementCondition().check(Array.get(array, i))) continue;
            ++counter;
        }
        return counter >= this.getCount();
    }

    protected boolean checkCollection(Collection collection) {
        int counter = 0;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            if (!this.getElementCondition().check(iter.next())) continue;
            ++counter;
        }
        return counter >= this.getCount();
    }

    public int getCount() {
        return this.count;
    }
}

