/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation.handler;

import java.lang.annotation.Annotation;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ClassValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ValidationAnnotationConfigurationException;
import org.springmodules.validation.bean.conf.loader.annotation.handler.Validator;
import org.springmodules.validation.bean.conf.loader.annotation.handler.Validators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorsClassValidationAnnotationHandler
implements ClassValidationAnnotationHandler {
    @Override
    public boolean supports(Annotation annotation, Class clazz) {
        return Validators.class.isInstance(annotation);
    }

    @Override
    public void handleAnnotation(Annotation annotation, Class clazz, MutableBeanValidationConfiguration configuration) {
        Validator[] validators = ((Validators)annotation).value();
        configuration.setCustomValidators(this.createValidators(validators));
    }

    protected org.springframework.validation.Validator[] createValidators(Validator[] validatorAnnotations) {
        org.springframework.validation.Validator[] validators = new org.springframework.validation.Validator[validatorAnnotations.length];
        for (int i = 0; i < validatorAnnotations.length; ++i) {
            validators[i] = this.createValidator(validatorAnnotations[i].value());
        }
        return validators;
    }

    protected org.springframework.validation.Validator createValidator(Class<? extends org.springframework.validation.Validator> validatorClass) {
        try {
            return validatorClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new ValidationAnnotationConfigurationException("Could not instantiate validator class '" + validatorClass.getName() + "'", iae);
        }
        catch (InstantiationException ie) {
            throw new ValidationAnnotationConfigurationException("Could not instantiate validator class '" + validatorClass.getName() + "'", ie);
        }
    }
}

