/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

public abstract class WebHijackPreventionStrategy {
    public static final WebHijackPreventionStrategy COMMENTS = new CommentWebHijackPreventionStrategy();
    public static final WebHijackPreventionStrategy INFINITE_LOOP = new InfiniteLoopWebHijackPreventionStrategy();

    public abstract String protect(String var1);

    private static final class InfiniteLoopWebHijackPreventionStrategy
    extends WebHijackPreventionStrategy {
        private InfiniteLoopWebHijackPreventionStrategy() {
        }

        public String protect(String str) {
            return "while(1);" + str;
        }
    }

    private static final class CommentWebHijackPreventionStrategy
    extends WebHijackPreventionStrategy {
        private CommentWebHijackPreventionStrategy() {
        }

        public String protect(String str) {
            return "/*" + str + "*/";
        }
    }
}

