/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.collect.Cache;
import com.google.appengine.repackaged.com.google.common.collect.CacheStats;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    @Deprecated
    public final V apply(K key) {
        return this.get(key);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<Map.Entry<K, V>> activeEntries(int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    @GoogleInternal
    public static CacheStats aggregate(StatsCounter ... stats) {
        SimpleStatsCounter aggregator = new SimpleStatsCounter();
        for (StatsCounter other : stats) {
            aggregator.incrementBy(other);
        }
        return aggregator.snapshot();
    }

    @Beta
    public static class SimpleStatsCounter
    implements StatsCounter {
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private final AtomicLong createCount = new AtomicLong();
        private final AtomicLong totalCreateTime = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();

        public void recordHit() {
            this.hitCount.incrementAndGet();
        }

        public void recordMiss() {
            this.missCount.incrementAndGet();
        }

        public void recordCreate(long createTime) {
            this.createCount.incrementAndGet();
            this.totalCreateTime.addAndGet(createTime);
        }

        public void recordEviction() {
            this.evictionCount.incrementAndGet();
        }

        public CacheStats snapshot() {
            return new CacheStats(this.hitCount.get(), this.missCount.get(), this.createCount.get(), this.totalCreateTime.get(), this.evictionCount.get());
        }

        public void incrementBy(StatsCounter other) {
            CacheStats otherStats = other.snapshot();
            this.hitCount.addAndGet(otherStats.hitCount());
            this.missCount.addAndGet(otherStats.missCount());
            this.createCount.addAndGet(otherStats.createCount());
            this.totalCreateTime.addAndGet(otherStats.totalCreateTime());
            this.evictionCount.addAndGet(otherStats.evictionCount());
        }
    }

    @Beta
    public static interface StatsCounter {
        public void recordHit();

        public void recordMiss();

        public void recordCreate(long var1);

        public void recordEviction();

        public CacheStats snapshot();
    }
}

