/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.datanucleus.store.valuegenerator.ValueGeneration;
import org.datanucleus.util.StringUtils;

public class ValueGenerationBlock
implements Serializable {
    private int nextIndex = 0;
    private final List valueList;

    public ValueGenerationBlock(Object[] values) {
        this.valueList = Arrays.asList(values);
    }

    public ValueGenerationBlock(List oid) {
        this.valueList = new ArrayList(oid);
    }

    public ValueGeneration current() {
        if (this.nextIndex == 0 || this.nextIndex - 1 >= this.valueList.size()) {
            throw new NoSuchElementException();
        }
        return new ValueGeneration(this.valueList.get(this.nextIndex - 1));
    }

    public ValueGeneration next() {
        if (this.nextIndex >= this.valueList.size()) {
            throw new NoSuchElementException();
        }
        return new ValueGeneration(this.valueList.get(this.nextIndex++));
    }

    public boolean hasNext() {
        return this.nextIndex < this.valueList.size();
    }

    public void addBlock(ValueGenerationBlock block) {
        if (block == null) {
            return;
        }
        while (block.hasNext()) {
            this.valueList.add(block.next());
        }
    }

    public String toString() {
        return "ValueGenerationBlock : " + StringUtils.collectionToString(this.valueList);
    }
}

