/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class StateManagerFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public static StateManager newStateManagerForHollow(ObjectManager om, Class pcClass, Object id) {
        Initialization stateManagerInitialization = new Initialization(om, pcClass);
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, null, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForHollowPreConstructed(ObjectManager om, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowPreConstructed(id, pc);
        return sm;
    }

    public static StateManager newStateManagerForHollowPopulated(ObjectManager om, Class pcClass, Object id, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(om, pcClass);
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForPersistentClean(ObjectManager om, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentClean(id, pc);
        return sm;
    }

    public static StateManager newStateManagerForHollowPopulatedAppId(ObjectManager om, Class pcClass, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(om, pcClass);
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowAppId(fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForEmbedded(ObjectManager om, Object pc, boolean copyPc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForEmbedded(pc, copyPc);
        return sm;
    }

    public static StateManager newStateManagerForPersistentNew(ObjectManager om, Object pc, FieldValues preInsertChanges) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentNew(pc, preInsertChanges);
        return sm;
    }

    public static StateManager newStateManagerForTransactionalTransient(ObjectManager om, Object pc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForTransactionalTransient(pc);
        return sm;
    }

    public static StateManager newStateManagerForDetached(ObjectManager om, Object pc, Object id, Object version) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForDetached(pc, id, version);
        return sm;
    }

    public static StateManager newStateManagerForPNewToBeDeleted(ObjectManager om, Object pc) {
        Initialization stateManagerInitialization = new Initialization(om, pc.getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPNewToBeDeleted(pc);
        return sm;
    }

    public static StateManager newStateManagerForCachedPC(ObjectManager om, Object id, CachedPC cachedPC) {
        Initialization stateManagerInitialization = new Initialization(om, cachedPC.getPersistableObject().getClass());
        StateManager sm = om.getApiAdapter().newStateManager(om, stateManagerInitialization.getClassMetaData());
        sm.initialiseForCachedPC(cachedPC, id, stateManagerInitialization.getPCClass());
        return sm;
    }

    protected static class Initialization {
        protected Class pcClass;
        protected AbstractClassMetaData cmd;

        protected Initialization(ObjectManager myOM, Class pcClass) {
            ClassLoaderResolver clr = myOM.getClassLoaderResolver();
            if (ClassUtils.isReferenceType(pcClass)) {
                this.cmd = myOM.getMetaDataManager().getMetaDataForImplementationOfReference(pcClass, null, clr);
                this.pcClass = clr.classForName(this.cmd.getFullClassName(), pcClass.getClassLoader(), true);
            } else {
                try {
                    this.pcClass = clr.classForName(pcClass.getName(), pcClass.getClassLoader(), true);
                    this.cmd = myOM.getMetaDataManager().getMetaDataForClass(pcClass, clr);
                }
                catch (ClassNotResolvedException e) {
                    throw new NucleusUserException(LOCALISER.msg("026015", (Object)pcClass.getName())).setFatal();
                }
            }
            if (this.cmd == null) {
                throw new NucleusUserException(LOCALISER.msg("026012", pcClass)).setFatal();
            }
        }

        protected Class getPCClass() {
            return this.pcClass;
        }

        protected AbstractClassMetaData getClassMetaData() {
            return this.cmd;
        }
    }
}

