/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQuerySplitter;
import com.google.appengine.api.datastore.EntityFilter;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InQuerySplitter
extends BaseQuerySplitter {
    InQuerySplitter() {
    }

    @Override
    public List<QuerySplitComponent> split(List<Query.FilterPredicate> remainingFilters, List<Query.SortPredicate> sorts, Set<EntityFilter> entityFilters) {
        ArrayList<QuerySplitComponent> result = new ArrayList<QuerySplitComponent>();
        Iterator<Query.FilterPredicate> itr = remainingFilters.iterator();
        while (itr.hasNext()) {
            Query.FilterPredicate filter = itr.next();
            if (filter.getOperator() != Query.FilterOperator.IN) continue;
            QuerySplitComponent component = new QuerySplitComponent(filter.getPropertyName(), sorts);
            ArrayList<BaseQuerySplitter.ComparableValue> comparableValues = new ArrayList<BaseQuerySplitter.ComparableValue>();
            for (Object t : (Iterable)filter.getValue()) {
                comparableValues.add(new BaseQuerySplitter.ComparableValue(t));
            }
            if (comparableValues.size() <= 1) continue;
            if (component.getDirection() != null) {
                Collections.sort(comparableValues, InQuerySplitter.getValueComparator(component.getDirection()));
            }
            for (BaseQuerySplitter.ComparableValue comparableValue : comparableValues) {
                component.addFilters(new Query.FilterPredicate(filter.getPropertyName(), Query.FilterOperator.EQUAL, comparableValue.getValue()));
            }
            result.add(component);
            itr.remove();
        }
        return result;
    }
}

