/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

public class Quota {
    public String quotaRoot;
    public Resource[] resources;

    public Quota(String quotaRoot) {
        this.quotaRoot = quotaRoot;
    }

    public void setResourceLimit(String name, long limit) {
        Resource target = this.findResource(name);
        target.limit = limit;
    }

    private Resource findResource(String name) {
        Resource target;
        if (this.resources == null) {
            Resource target2 = new Resource(name, 0L, 0L);
            this.resources = new Resource[]{target2};
            return target2;
        }
        for (int i = 0; i < this.resources.length; ++i) {
            Resource current = this.resources[i];
            if (!current.name.equalsIgnoreCase(name)) continue;
            return current;
        }
        Resource[] newResources = new Resource[this.resources.length + 1];
        System.arraycopy(this.resources, 0, newResources, 0, this.resources.length);
        newResources[this.resources.length] = target = new Resource(name, 0L, 0L);
        this.resources = newResources;
        return target;
    }

    public static class Resource {
        public String name;
        public long usage;
        public long limit;

        public Resource(String name, long usage, long limit) {
            this.name = name;
            this.usage = usage;
            this.limit = limit;
        }
    }
}

