<%@page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%
  final String path = request.getContextPath();
%>

<div id="subscribeDiv" class="frontForm">
 <form id="subscribeForm" method="POST" action="<%=path%>/subscribe.html" >
  <table>
    <tr><td class="title" colspan="2"><fmt:message key="subscribe.title"/></td></tr>
    <tr><td class="error" colspan="2" id="subscribeForm-message" /></td></tr>
    <tr>
      <td class="label"><fmt:message key="subscribe.email"/></td>
      <td class="field"><input id="email" name="email" type="text" /></td>
    </tr>
    <tr>
      <td class="label"><fmt:message key="subscribe.firstname"/></label></td>
      <td class="field"><input id="firstname" name="firstname" type="text" /></td>
    </tr>
    <tr>
      <td class="label"><fmt:message key="subscribe.lastname"/></label></td>
      <td class="field"><input id="lastname" name="lastname" type="text" /></td>
    </tr>
    <tr>
      <td class="label"><fmt:message key="subscribe.password"/></label></td>
      <td class="field"><input id="password" name="password" type="password" /></td>
    </tr>
    <tr>
      <td class="label"><fmt:message key="subscribe.confirm"/></label></td>
      <td class="field"><input id="confirm" name="confirm" type="password" /></td>
    </tr>

    <tr><td class="button" colspan="2"><input id="buttonSubscribe" class="submit" type="submit" value="Register" /></td></tr>
  </table>
  <%--fieldset>
    <legend class="title"><fmt:message key="subscribe.title"/></legend>
    <label class="error" id="subscribeForm-message" />
    <label for="email"><fmt:message key="subscribe.email"/></label>
    <input id="email" name="email" type="text" />

    <label for="firstname"><fmt:message key="subscribe.firstname"/></label>
    <input id="firstname" name="firstname" type="text" />

    <label for="lastname"><fmt:message key="subscribe.lastname"/></label>
    <input id="lastname" name="lastname" type="text" />

    <label for="password"><fmt:message key="subscribe.password"/></label>
    <input id="password" name="password" type="password" />

    <label for="confirm"><fmt:message key="subscribe.confirm"/></label>
    <input id="confirm" name="confirm" type="password" />

    <input id="buttonSubscribe" class="submit" type="submit" value="Register" />
    <!--button id="buttonSubscribe" class="submit"><fmt:message key="subscribe.button"/></button-->
  </fieldset--%>
 </form>
 <script type="text/javascript">
 $(document).ready(function() {
   new setupAjaxForm(
      'subscribeForm', false, 
      function(){ 
        // field validations go here, make sure to return true (validates) / false (fails).
        return true;
      },
      subscribeSuccess
   );
 });
 // ******* LOGIN FORM SUCCESS ********
 function subscribeSuccess(json){
  if (json.result == 'OK') {
    document.getElementById("message").innerHtml = json.success;
  }  
 }
</script>
</div>
