/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.oauth;

import com.google.appengine.api.oauth.InvalidOAuthParametersException;
import com.google.appengine.api.oauth.InvalidOAuthTokenException;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.oauth.OAuthServiceFailureException;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserServicePb;

final class OAuthServiceImpl
implements OAuthService {
    static final String GET_OAUTH_USER_RESPONSE_KEY = "com.google.appengine.api.oauth.OAuthService.get_oauth_user_response";
    private static final String PACKAGE = "user";
    private static final String CHECK_SIGNATURE_METHOD = "CheckOAuthSignature";
    private static final String GET_OAUTH_USER_METHOD = "GetOAuthUser";

    OAuthServiceImpl() {
    }

    public User getCurrentUser() throws OAuthRequestException {
        UserServicePb.GetOAuthUserResponse response = this.getGetOAuthUserResponse();
        return new User(response.getEmail(), response.getAuthDomain(), response.getUserId());
    }

    public boolean isUserAdmin() throws OAuthRequestException {
        UserServicePb.GetOAuthUserResponse response = this.getGetOAuthUserResponse();
        return response.isIsAdmin();
    }

    public String getOAuthConsumerKey() throws OAuthRequestException {
        UserServicePb.CheckOAuthSignatureRequest request = new UserServicePb.CheckOAuthSignatureRequest();
        byte[] responseBytes = this.makeSyncCall(CHECK_SIGNATURE_METHOD, request);
        UserServicePb.CheckOAuthSignatureResponse response = new UserServicePb.CheckOAuthSignatureResponse();
        response.mergeFrom(responseBytes);
        return response.getOauthConsumerKey();
    }

    private UserServicePb.GetOAuthUserResponse getGetOAuthUserResponse() throws OAuthRequestException {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        UserServicePb.GetOAuthUserResponse response = (UserServicePb.GetOAuthUserResponse)environment.getAttributes().get(GET_OAUTH_USER_RESPONSE_KEY);
        if (response == null) {
            UserServicePb.GetOAuthUserRequest request = new UserServicePb.GetOAuthUserRequest();
            byte[] responseBytes = this.makeSyncCall(GET_OAUTH_USER_METHOD, request);
            response = new UserServicePb.GetOAuthUserResponse();
            response.mergeFrom(responseBytes);
            environment.getAttributes().put(GET_OAUTH_USER_RESPONSE_KEY, response);
        }
        return response;
    }

    private byte[] makeSyncCall(String methodName, ProtocolMessage request) throws OAuthRequestException {
        byte[] responseBytes;
        try {
            byte[] requestBytes = request.toByteArray();
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, requestBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            UserServicePb.UserServiceError.ErrorCode errorCode = UserServicePb.UserServiceError.ErrorCode.valueOf(ex.getApplicationError());
            switch (errorCode) {
                case NOT_ALLOWED: 
                case OAUTH_INVALID_REQUEST: {
                    throw new InvalidOAuthParametersException(ex.getErrorDetail());
                }
                case OAUTH_INVALID_TOKEN: {
                    throw new InvalidOAuthTokenException(ex.getErrorDetail());
                }
            }
            throw new OAuthServiceFailureException(ex.getErrorDetail());
        }
        return responseBytes;
    }
}

