/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.collect.AbstractCache;
import com.google.appengine.repackaged.com.google.common.collect.AsynchronousComputationException;
import com.google.appengine.repackaged.com.google.common.collect.CacheLoader;
import com.google.appengine.repackaged.com.google.common.collect.CacheStats;
import com.google.appengine.repackaged.com.google.common.collect.ComputationException;
import com.google.appengine.repackaged.com.google.common.collect.ComputingConcurrentHashMap;
import com.google.appengine.repackaged.com.google.common.collect.CustomConcurrentHashMap;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingConcurrentMap;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
class ComputingCache<K, V>
extends AbstractCache<K, V> {
    @VisibleForTesting
    final ComputingConcurrentHashMap<K, V> map;
    ConcurrentMap<K, V> asMap;

    ComputingCache(MapMaker builder, Supplier<? extends AbstractCache.StatsCounter> statsCounterSupplier, CacheLoader<? super K, V> loader) {
        this.map = new ComputingConcurrentHashMap<K, V>(builder, statsCounterSupplier, loader);
    }

    @Override
    public V get(K key) {
        try {
            return this.map.compute(key);
        }
        catch (ComputingConcurrentHashMap.AsynchronousExecutionException e) {
            throw new AsynchronousComputationException(e.getCause());
        }
        catch (ExecutionException e) {
            throw new ComputationException(e.getCause());
        }
    }

    @Override
    public V getChecked(K key) throws ExecutionException {
        return this.map.compute(key);
    }

    @Override
    public void invalidate(Object key) {
        this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        ConcurrentMap<K, V> am = this.asMap;
        return am != null ? am : (this.asMap = new CacheAsMap<K, V>(this.map));
    }

    @Override
    public CacheStats stats() {
        AbstractCache.SimpleStatsCounter aggregator = new AbstractCache.SimpleStatsCounter();
        for (CustomConcurrentHashMap.Segment segment : this.map.segments) {
            aggregator.incrementBy(segment.statsCounter);
        }
        return aggregator.snapshot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CacheAsMap<K, V>
    extends ForwardingConcurrentMap<K, V> {
        private final ConcurrentMap<K, V> delegate;

        CacheAsMap(ConcurrentMap<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }
    }
}

