/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.CollectionStoreQueryable;
import org.datanucleus.store.mapped.expression.ContainerSizeExpression;
import org.datanucleus.store.mapped.expression.ExistsExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.scostore.CollectionStore;

public class CollectionExpression
extends ScalarExpression {
    private final CollectionStore collStore;
    private final String fieldName;

    public CollectionExpression(QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, CollectionStore collStore, String fieldName) {
        super(qs);
        this.mapping = ownerMapping;
        this.collStore = collStore;
        this.fieldName = fieldName;
        this.te = te;
    }

    public NumericExpression sizeMethod() {
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String ctIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifierName();
        DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(IdentifierType.TABLE, ctIdentifier);
        return new ContainerSizeExpression(this.qs, this.getBackingStoreQueryable().getSizeSubquery(this.qs, this.mapping, this.te, ctRangeVar));
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        DatastoreIdentifier elementTableAlias;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            if (var.getVariableType() == null) {
                var.setVariableType(clr.classForName(this.collStore.getElementType()));
            }
            String existsTableId = idFactory.newIdentifier(idFactory.newIdentifier(this.te.getAlias(), this.fieldName), var.getVariableName()).getIdentifierName();
            DatastoreIdentifier existsTableAlias = idFactory.newIdentifier(IdentifierType.TABLE, existsTableId);
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, existsTableAlias);
            DatastoreIdentifier elementTableAlias2 = null;
            if (expr.te == null) {
                String elementTableId = "UNBOUND." + var.getVariableName();
                elementTableAlias2 = idFactory.newIdentifier(IdentifierType.TABLE, elementTableId);
            } else {
                elementTableAlias2 = expr.te.getAlias();
            }
            ScalarExpression joinExpr = this.getBackingStoreQueryable().joinElementsTo(qexpr, this.qs, this.mapping, this.te, existsTableAlias, var.getVariableType(), expr, elementTableAlias2, true);
            var.bindTo(joinExpr);
            LogicSetExpression elementTblExpr = this.qs.getTableExpression(elementTableAlias2);
            if (this.qs.hasCrossJoin(elementTblExpr)) {
                qexpr.andCondition(joinExpr.eq(expr.mapping.newScalarExpression(this.qs, elementTblExpr)));
            }
            return new ExistsExpression(this.qs, qexpr, true);
        }
        String existsTableId = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifierName();
        DatastoreIdentifier existsTableAlias = idFactory.newIdentifier(IdentifierType.TABLE, existsTableId);
        if (expr.te == null) {
            String elementTableId;
            int n = 0;
            while (this.qs.getTableExpression(elementTableAlias = idFactory.newIdentifier(IdentifierType.TABLE, elementTableId = existsTableId + '.' + ++n)) != null) {
            }
        } else {
            elementTableAlias = expr.te.getAlias();
        }
        if (expr instanceof Literal) {
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, existsTableAlias);
            ScalarExpression joinExpr = this.getBackingStoreQueryable().joinElementsTo(qexpr, this.qs, this.mapping, this.te, existsTableAlias, clr.classForName(expr.getMapping().getType()), expr, elementTableAlias, true);
            if (!expr.equals(joinExpr)) {
                qexpr.andCondition(expr.eq(joinExpr));
            }
            return new ExistsExpression(this.qs, qexpr, true);
        }
        boolean existsAlways = false;
        Object ext = expr.qs.getValueForExtension("datanucleus.rdbms.query.containsUsesExistsAlways");
        if (ext != null && ((String)ext).equals("true")) {
            existsAlways = true;
        }
        if (existsAlways) {
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, existsTableAlias);
            ScalarExpression joinExpr = this.getBackingStoreQueryable().joinElementsTo(qexpr, this.qs, this.mapping, this.te, existsTableAlias, clr.classForName(expr.getMapping().getType()), expr, elementTableAlias, true);
            if (!expr.equals(joinExpr)) {
                qexpr.andCondition(expr.eq(joinExpr));
            }
            return new ExistsExpression(this.qs, qexpr, true);
        }
        ScalarExpression joinExpr = this.getBackingStoreQueryable().joinElementsTo(expr.getQueryExpression(), this.qs, this.mapping, this.te, existsTableAlias, clr.classForName(this.collStore.getElementType()), expr, elementTableAlias, false);
        return joinExpr.eq(expr);
    }

    public BooleanExpression isEmptyMethod() {
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String existsTableId = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifierName();
        DatastoreIdentifier existsTableAlias = idFactory.newIdentifier(IdentifierType.TABLE, existsTableId);
        QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, existsTableAlias);
        return new ExistsExpression(this.qs, qexpr, false);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return this.isEmptyMethod();
        }
        throw new NucleusUserException(LOCALISER.msg("037004"));
    }

    public StatementText toStatementText(int mode) {
        throw new NucleusUserException("Cannot reference collection object directly: field name = " + this.fieldName);
    }

    private CollectionStoreQueryable getBackingStoreQueryable() {
        return (CollectionStoreQueryable)((Object)this.collStore);
    }
}

