package com.jispot.common;

import java.lang.reflect.Array;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {

    /**
     * Test if the pattern matches the data<br>
     * 
     * <pre>
     *  pattern  |   data    |   Return
     * __________|___________|_____________ 
     *    null   |    *      |    Null
     *     *     |    null   |    Null
     *   empty   |   !null   |   false 
     *    ok     |   !null   |  matches()
     * </pre>
     * 
     * 
     * @param pattern
     * @param data
     * @return pattern matches data
     */
    public static Boolean testRegExp( String pattern , String data ) {
        if ( pattern != null && data != null ) {
            if ( !pattern.isEmpty() ) {
                Pattern p = Pattern.compile( pattern );
                Matcher matcher = p.matcher( data );
                return matcher.matches();
            }
            return true;
        }
        return null;
    }

    /**
     * Just tests if a String is null or empty
     * 
     * @param string the string to test
     * @return true if the String is null or empty
     */
    public static boolean isNullOrEmpty( String string ) {
        return ( string == null || "".equals( string.trim() ) );
    }

    /**
     * Just tests if a String is not null and not empty
     * 
     * @param string the string to test
     * @return true if the String is NOT null and NOT empty
     */
    public static boolean isNotNullOrEmpty( String string ) {
        return ! isNullOrEmpty(string);
    }

    /**
     * Méthode permettant de remplacer dans une chaine de caractères, toutes les occurrences d'une
     * chaine de caractères par une autre.
     * 
     * @param chaine la chaine à modifier
     * @param ancien la chaine à remplacer
     * @param nouveau chaine par laquelle on remplace
     * @return La chaine modifi?e
     */
    public static String replaceAll( String string , final String ancien , final String nouveau ) {
        if ( isNullOrEmpty( string ) ) {
            return string;
        }
        int currentIndex = -1;
        currentIndex = string.indexOf( ancien , currentIndex );
        while ( currentIndex >= 0 ) {
            string = replace( string , ancien , nouveau , currentIndex );
            currentIndex = string.indexOf( ancien , currentIndex + nouveau.length() );
        }
        return string;
    }

    /**
     * Méthode permettant de remplacer dans une chaine de caractères, une chaine de caractères
     * par une autre, en commençant à partir d'un point donné.<br>
     * Méthode équivalente aux fonctions java pour remplacer un caractère.
     * 
     * @param chaine la chaine à modifier
     * @param aChercher la chaine à remplacer
     * @param remplacerPar chaine par laquelle on remplace
     * @param startingIndex index à partir duquel on démarre
     * @return La chaine modifiée
     */
    public static String replace( String chaine , final String aChercher , final String remplacerPar ,
            final int startingIndex ) {
        if ( chaine == null ) return null;
        final int i = chaine.indexOf( aChercher , startingIndex );
        if ( i >= 0 ) {
            final int longueur = aChercher.length();
            chaine = chaine.substring( 0 , i ).concat( remplacerPar ).concat( chaine.substring( i + longueur ) );
        }
        return chaine;

    }

    /**
     * Fonction utilisée pour remplacer un caractère par une chaine de caractère
     * 
     * @param aString Chaine à traiter
     * @param aOld Caractère à remplacer
     * @param aNew Chaine de remplacement
     * @return Chaine avec le remplacement réalisé
     */
    public static String replaceChar( final String aString , final char aOld , final String aNew ) {

        final int llength = aString.length();
        final StringBuffer lreturn = new StringBuffer( aString.length() );
        if ( llength == -1 ) {
            return "";
        }
        else {

            char c;
            for ( int i = 0 ; i < llength ; i++ ) {
                c = aString.charAt( i );
                if ( c == aOld ) {
                    lreturn.append( aNew );
                }
                else {
                    lreturn.append( c );
                }
            }
        }
        return lreturn.toString();
    }

   /**
	 * It permits to replace the "{number} " of the text by the corresponding
	 * string passed in attribute.<br>
     * Numbers must start with 0 and increments A each time : 0,1,2,3...
	 * 
	 * @param text Text with tokens like: Hello {0}, my name is {1} and I'm in the {2}!
	 * @param params Array containing params to fill the tokens: ["John", "Brian", "kitchen"]
	 * @return text Text completed: Hello John, my name is Brian and I'm in the kitchen!
	 */
	public static String replaceParams(String text, String[] params ) {
        return replaceParams( text , ( Object[] ) params ) ;
    }

   /**
	 * It permits to replace the "{number} " of the text by the corresponding
	 * string passed in attribute.<br>
     * Numbers must start with 0 and increments A each time : 0,1,2,3...
	 * 
	 * @param text Text with tokens like: Hello {0}, my name is {1} and I'm in the {2}!
	 * @param params Array containing params to fill the tokens: ["John", "Brian", "kitchen"]
	 * @return text Text completed: Hello John, my name is Brian and I'm in the kitchen!
	 */
	public static String replaceParams(String text, Object[] params ) {

		int nbParams = params.length;
		String textResult = text;

		for (int i = 0; i < nbParams; i++) {
			textResult = StringUtils.replaceAll(textResult, "{" + i + "}", params[i].toString() );
		}

		return textResult;
	}

    /**
     * Capitalized the first Character of a String
     * 
     * @param string the string which we want to Capitalized the first letter
     * @return
     */
    public static String capitalizeFirst( final String string ) {
        if ( isNullOrEmpty( string ) ) {
            return null;
        }
        final StringBuffer ok = new StringBuffer( string.length() );
        ok.append( string.substring( 0 , 1 ).toUpperCase() );
        ok.append( string.substring( 1 ) );
        return ok.toString();
    }

    public static String getRandomText( int size ) {
        StringBuffer pass = new StringBuffer( size );
        int c = 'A';
        int r1 = 0;
        for ( int i = 0 ; i < size ; i++ ) {
            r1 = ( int ) ( Math.random() * 3 );
            switch ( r1 ) {
                case 0:
                    c = '0' + ( int ) ( Math.random() * 10 );
                    break;
                case 1:
                    c = 'a' + ( int ) ( Math.random() * 26 );
                    break;
                case 2:
                    c = 'A' + ( int ) ( Math.random() * 26 );
                    break;
            }
            pass.append( ( char ) c );
        }
        return pass.toString();
    }

    /**
     * Extract extension from a fileName, absolute path or relative path
     * 
     * @param fileName
     * @return extension
     */
    public static String getExtensionFromFileName( String fileName ) {
        String result = "";
        int indexStartExtension = fileName.lastIndexOf( "." );
        result = fileName.substring( indexStartExtension , fileName.length() );
        return result;
    }

    /**
     * Extract file name without extension from an absolute path or relative path
     * 
     * @param path
     * @return
     */
    public static String getFileName( String path ) {
        String result = "";
        int indexStartFileName = path.lastIndexOf( "/" );
        if ( indexStartFileName == -1 ) {
            indexStartFileName = 0;
        }

        int indexStartExtension = path.lastIndexOf( "." );

        if ( indexStartExtension == -1 ) {
            indexStartExtension = path.length();
        }
        result = path.substring( indexStartFileName , indexStartExtension );
        return result;
    }

    /**
     * Extract file path without file name and whitout last / from an absolute path or relative path
     * 
     * @param path
     * @return
     */
    public static String getPath( String path ) {
        String result = "";
        int indexStartFileName = path.lastIndexOf( "/" );
        result = path.substring( 0 , indexStartFileName );
        return result;
    }

    public static boolean isTrue( String val ) {
        if ( "true".equalsIgnoreCase( val ) || "yes".equalsIgnoreCase( val ) || "on".equalsIgnoreCase( val )
                || "1".equalsIgnoreCase( val ) ) {
            return true;
        }
        return false;
    }

    /**
     * Expands an array of anything
     * @param array
     * @return
     */
    public static Object expand( Object array ) {
        Class cl = array.getClass();
        if ( !cl.isArray() ) return null;
        int length = Array.getLength( array );
        int newLength = length + ( length / 2 ); // 50% more
        Class componentType = array.getClass().getComponentType();
        Object newArray = Array.newInstance( componentType , newLength );
        System.arraycopy( array , 0 , newArray , 0 , length );
        return newArray;
    }

}
