/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CollectionToCollectionConverter
implements ConditionalGenericConverter {
    private final GenericConversionService conversionService;

    public CollectionToCollectionConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType.getElementTypeDescriptor(), targetType.getElementTypeDescriptor());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Collection sourceCollection = (Collection)source;
        TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
        if (sourceElementType == TypeDescriptor.NULL) {
            sourceElementType = ConversionUtils.getElementType(sourceCollection);
        }
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        if (sourceElementType == TypeDescriptor.NULL || targetElementType == TypeDescriptor.NULL || sourceElementType.isAssignableTo(targetElementType)) {
            if (sourceType.isAssignableTo(targetType)) {
                return sourceCollection;
            }
            Collection target = CollectionFactory.createCollection(targetType.getType(), sourceCollection.size());
            target.addAll(sourceCollection);
            return target;
        }
        Collection target = CollectionFactory.createCollection(targetType.getType(), sourceCollection.size());
        GenericConverter converter = this.conversionService.getConverter(sourceElementType, targetElementType);
        if (converter == null) {
            throw new ConverterNotFoundException(sourceElementType, targetElementType);
        }
        for (Object element : sourceCollection) {
            target.add(ConversionUtils.invokeConverter(converter, element, sourceElementType, targetElementType));
        }
        return target;
    }
}

