/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestClientException;

public abstract class HttpStatusCodeException
extends RestClientException {
    private final HttpStatus statusCode;
    private final String statusText;

    protected HttpStatusCodeException(HttpStatus statusCode) {
        super(statusCode.toString());
        this.statusCode = statusCode;
        this.statusText = statusCode.name();
    }

    protected HttpStatusCodeException(HttpStatus statusCode, String statusText) {
        super(String.valueOf(statusCode.value()) + " " + statusText);
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }
}

