/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class VariableReference
extends SpelNodeImpl {
    private static final String THIS = "this";
    private static final String ROOT = "root";
    private final String name;

    public VariableReference(String variableName, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.name = variableName;
    }

    public TypedValue getValueInternal(ExpressionState state) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return state.getActiveContextObject();
        }
        if (this.name.equals(ROOT)) {
            return state.getRootContextObject();
        }
        TypedValue result = state.lookupVariable(this.name);
        return result;
    }

    public void setValue(ExpressionState state, Object value) throws SpelEvaluationException {
        state.setVariable(this.name, value);
    }

    public String toStringAST() {
        return "#" + this.name;
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return !this.name.equals(THIS) && !this.name.equals(ROOT);
    }
}

