/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ApiAdapterFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerImpl.class.getClassLoader());
    HashMap adapters = new HashMap();
    static ApiAdapterFactory adapterFactory = new ApiAdapterFactory();

    public static ApiAdapterFactory getInstance() {
        return adapterFactory;
    }

    protected ApiAdapterFactory() {
    }

    private void addAdapter(String name, ApiAdapter apiAdapter) {
        if (name == null || apiAdapter == null) {
            return;
        }
        this.adapters.put(name, apiAdapter);
    }

    public ApiAdapter getApiAdapter(String name, PluginManager pluginMgr) {
        ApiAdapter api = (ApiAdapter)this.adapters.get(name);
        if (api == null) {
            try {
                api = (ApiAdapter)pluginMgr.createExecutableExtension("org.datanucleus.api_adapter", "name", name, "class-name", null, null);
                adapterFactory.addAdapter(name, api);
            }
            catch (Error err) {
                String className = pluginMgr.getAttributeValueForExtension("org.datanucleus.api_adapter", "name", name, "class-name");
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("022000", (Object)className, (Object)err.getMessage()));
            }
            catch (InvocationTargetException e) {
                String className = pluginMgr.getAttributeValueForExtension("org.datanucleus.api_adapter", "name", name, "class-name");
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("022000", (Object)className, (Object)e.getTargetException()));
            }
            catch (Exception e) {
                String className = pluginMgr.getAttributeValueForExtension("org.datanucleus.api_adapter", "name", name, "class-name");
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("022000", (Object)className, (Object)e));
            }
        }
        return api;
    }
}

