/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;

public class VersionStrategy
implements Serializable {
    public static final VersionStrategy NONE = new VersionStrategy(0);
    public static final VersionStrategy STATE_IMAGE = new VersionStrategy(1);
    public static final VersionStrategy DATE_TIME = new VersionStrategy(2);
    public static final VersionStrategy VERSION_NUMBER = new VersionStrategy(3);
    private final int typeId;

    private VersionStrategy(int i) {
        this.typeId = i;
    }

    public boolean equals(Object o) {
        if (o instanceof VersionStrategy) {
            return ((VersionStrategy)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 0: {
                return "none";
            }
            case 1: {
                return "state-image";
            }
            case 2: {
                return "date-time";
            }
            case 3: {
                return "version-number";
            }
        }
        return "";
    }

    protected int getType() {
        return this.typeId;
    }

    public static VersionStrategy getVersionStrategy(String value) {
        if (value == null) {
            return null;
        }
        if (NONE.toString().equalsIgnoreCase(value)) {
            return NONE;
        }
        if (STATE_IMAGE.toString().equalsIgnoreCase(value)) {
            return STATE_IMAGE;
        }
        if (DATE_TIME.toString().equalsIgnoreCase(value)) {
            return DATE_TIME;
        }
        if (VERSION_NUMBER.toString().equalsIgnoreCase(value)) {
            return VERSION_NUMBER;
        }
        return null;
    }
}

