/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.OpenJpaDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final PersistenceProvider persistenceProvider = new PersistenceProviderImpl();
    private final OpenJpaDialect jpaDialect = new OpenJpaDialect();

    @Override
    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    @Override
    public String getPersistenceProviderRootPackage() {
        return "org.apache.openjpa";
    }

    public Map<String, Object> getJpaPropertyMap() {
        String databaseDictonary;
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("openjpa.jdbc.DBDictionary", this.getDatabasePlatform());
        } else if (this.getDatabase() != null && (databaseDictonary = this.determineDatabaseDictionary(this.getDatabase())) != null) {
            jpaProperties.put("openjpa.jdbc.DBDictionary", databaseDictonary);
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        }
        if (this.isShowSql()) {
            jpaProperties.put("openjpa.Log", "DefaultLevel=WARN, Runtime=INFO, Tool=INFO, SQL=TRACE");
        }
        return jpaProperties;
    }

    protected String determineDatabaseDictionary(Database database) {
        switch (database) {
            case DB2: {
                return "db2";
            }
            case DERBY: {
                return "derby";
            }
            case HSQL: {
                return "hsql(SimulateLocking=true)";
            }
            case INFORMIX: {
                return "informix";
            }
            case MYSQL: {
                return "mysql";
            }
            case ORACLE: {
                return "oracle";
            }
            case POSTGRESQL: {
                return "postgres";
            }
            case SQL_SERVER: {
                return "sqlserver";
            }
            case SYBASE: {
                return "sybase";
            }
        }
        return null;
    }

    @Override
    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    @Override
    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return OpenJPAEntityManagerFactorySPI.class;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return OpenJPAEntityManagerSPI.class;
    }
}

