/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import java.util.Arrays;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.store.appengine.FatalNucleusUserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StorageVersion {
    PARENTS_DO_NOT_REFER_TO_CHILDREN,
    WRITE_OWNED_CHILD_KEYS_TO_PARENTS,
    READ_OWNED_CHILD_KEYS_FROM_PARENTS;

    static final String STORAGE_VERSION_PROPERTY = "datanucleus.appengine.storageVersion";
    private static final StorageVersion DEFAULT;

    static StorageVersion fromConfig(PersistenceConfiguration pc) {
        String val = pc.getStringProperty(STORAGE_VERSION_PROPERTY);
        if (val == null) {
            return DEFAULT;
        }
        try {
            return StorageVersion.valueOf(val);
        }
        catch (IllegalArgumentException iae) {
            throw new FatalNucleusUserException(String.format("'%s' is an unknwon value for %s.  Legal values are %s.", val, STORAGE_VERSION_PROPERTY, Arrays.toString((Object[])StorageVersion.values())));
        }
    }

    static {
        DEFAULT = PARENTS_DO_NOT_REFER_TO_CHILDREN;
    }
}

