/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition;

import org.springmodules.validation.util.condition.AbstractCondition;

public abstract class TypeSpecificCondition
extends AbstractCondition {
    private Class[] types;

    public TypeSpecificCondition(Class type) {
        this(new Class[]{type});
    }

    public TypeSpecificCondition(Class[] types) {
        this.types = types;
    }

    protected void beforeObjectChecked(Object object) {
        boolean foundMatchingType = false;
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isAssignableFrom(object.getClass())) continue;
            foundMatchingType = true;
            break;
        }
        if (!foundMatchingType) {
            StringBuffer message = new StringBuffer(this.getClass().getName());
            message.append("can only validation values of the following types: ");
            for (int j = 0; j < this.types.length; ++j) {
                if (j != 0) {
                    message.append(", ");
                }
                message.append(this.types[j].getName());
            }
            throw new IllegalArgumentException(message.toString());
        }
    }
}

