package com.jispot.domain.model;

import siena.Column;
import siena.Filter;
import siena.Generator;
import siena.Id;
import siena.Max;
import siena.Model;
import siena.NotNull;
import siena.Query;
import siena.Table;
import siena.Unique;

@Table("spotter")
public class Spotter extends Model {

	@Id(Generator.AUTO_INCREMENT)
	public Long id;

	@Column("login")
	@Max(200)
	@NotNull
    @Unique("login_index")
	public String login;

	@Column("password")
	@Max(200) @NotNull
	public String password;

	@Column("email")
	@Max(300)
	@NotNull
	public String email;

	@Column("first_name")
	@Max(200) @NotNull
	public String firstName;

	@Column("last_name")
	@Max(200) @NotNull
	public String lastName;

	@Filter("friends")
	public Query<Spotter> friends;

	@Filter("spots")
	public Query<Spot> spots;

	@Filter("parameters")
	public Query<Parameter> parameters;

	public static Query<Spotter> all() {
		return Model.all(Spotter.class);
	}

}