/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteDomain;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import com.google.appengine.repackaged.com.google.common.primitives.Booleans;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class Cut<C extends Comparable>
implements Comparable<Cut<C>> {
    final C endpoint;
    static final Cut<Comparable<?>> BELOW_ALL = new Cut<Comparable<?>>(null){

        @Override
        Comparable<?> endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        boolean isLessThan(Comparable<?> value) {
            return true;
        }

        @Override
        Range.BoundType typeAsLowerBound() {
            throw new IllegalStateException();
        }

        @Override
        Range.BoundType typeAsUpperBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append("(-\u221e");
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        Comparable<?> leastValueAbove(DiscreteDomain<Comparable<?>> domain) {
            return domain.minValue();
        }

        @Override
        Comparable<?> greatestValueBelow(DiscreteDomain<Comparable<?>> domain) {
            throw new AssertionError();
        }

        @Override
        Cut<Comparable<?>> canonical(DiscreteDomain<Comparable<?>> domain) {
            try {
                return new BelowValue(domain.minValue());
            }
            catch (NoSuchElementException e) {
                return this;
            }
        }

        @Override
        public int compareTo(Cut<Comparable<?>> o) {
            return o == this ? 0 : -1;
        }
    };
    static final Cut<Comparable<?>> ABOVE_ALL = new Cut<Comparable<?>>(null){

        @Override
        Comparable<?> endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        boolean isLessThan(Comparable<?> value) {
            return false;
        }

        @Override
        Range.BoundType typeAsLowerBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        Range.BoundType typeAsUpperBound() {
            throw new IllegalStateException();
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append("+\u221e)");
        }

        @Override
        Comparable<?> leastValueAbove(DiscreteDomain<Comparable<?>> domain) {
            throw new AssertionError();
        }

        @Override
        Comparable<?> greatestValueBelow(DiscreteDomain<Comparable<?>> domain) {
            return domain.maxValue();
        }

        @Override
        public int compareTo(Cut<Comparable<?>> o) {
            return o == this ? 0 : 1;
        }
    };

    Cut(C endpoint) {
        this.endpoint = endpoint;
    }

    abstract boolean isLessThan(C var1);

    abstract Range.BoundType typeAsLowerBound();

    abstract Range.BoundType typeAsUpperBound();

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    abstract C leastValueAbove(DiscreteDomain<C> var1);

    abstract C greatestValueBelow(DiscreteDomain<C> var1);

    Cut<C> canonical(DiscreteDomain<C> domain) {
        return this;
    }

    @Override
    public int compareTo(Cut<C> that) {
        if (that == BELOW_ALL) {
            return 1;
        }
        if (that == ABOVE_ALL) {
            return -1;
        }
        int result = Cut.compareOrThrow(this.endpoint, that.endpoint);
        if (result != 0) {
            return result;
        }
        return Booleans.compare(this instanceof AboveValue, that instanceof AboveValue);
    }

    C endpoint() {
        return this.endpoint;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Cut) {
            Cut that = (Cut)obj;
            try {
                int compareResult = this.compareTo(that);
                return compareResult == 0;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    private static int compareOrThrow(Comparable left, Comparable right) {
        return left.compareTo(right);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AboveValue<C extends Comparable>
    extends Cut<C> {
        AboveValue(C endpoint) {
            super((Comparable)Preconditions.checkNotNull(endpoint));
        }

        @Override
        boolean isLessThan(C value) {
            return Cut.compareOrThrow(this.endpoint, value) < 0;
        }

        @Override
        Range.BoundType typeAsLowerBound() {
            return Range.BoundType.OPEN;
        }

        @Override
        Range.BoundType typeAsUpperBound() {
            return Range.BoundType.CLOSED;
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append('(').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(']');
        }

        @Override
        C leastValueAbove(DiscreteDomain<C> domain) {
            return (C)domain.next(this.endpoint);
        }

        @Override
        C greatestValueBelow(DiscreteDomain<C> domain) {
            return (C)this.endpoint;
        }

        @Override
        Cut<C> canonical(DiscreteDomain<C> domain) {
            C next = this.leastValueAbove(domain);
            if (next != null) {
                return new BelowValue<C>(next);
            }
            Cut aboveAll = ABOVE_ALL;
            return aboveAll;
        }

        public int hashCode() {
            return ~this.endpoint.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BelowValue<C extends Comparable>
    extends Cut<C> {
        BelowValue(C endpoint) {
            super((Comparable)Preconditions.checkNotNull(endpoint));
        }

        @Override
        boolean isLessThan(C value) {
            return Cut.compareOrThrow(this.endpoint, value) <= 0;
        }

        @Override
        Range.BoundType typeAsLowerBound() {
            return Range.BoundType.CLOSED;
        }

        @Override
        Range.BoundType typeAsUpperBound() {
            return Range.BoundType.OPEN;
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append('[').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(')');
        }

        @Override
        C leastValueAbove(DiscreteDomain<C> domain) {
            return (C)this.endpoint;
        }

        @Override
        C greatestValueBelow(DiscreteDomain<C> domain) {
            return (C)domain.previous(this.endpoint);
        }

        public int hashCode() {
            return this.endpoint.hashCode();
        }
    }
}

