/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.scostore.AbstractListStore;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.FKListStoreSpecialization;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class FKListStore
extends AbstractListStore {
    private final int ownerFieldNumber;

    public FKListStore(AbstractMemberMetaData fmd, MappedStoreManager storeMgr, ClassLoaderResolver clr, FKListStoreSpecialization specialization) {
        super((StoreManager)storeMgr, clr, specialization);
        this.setOwner(fmd, clr);
        CollectionMetaData colmd = fmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056001", (Object)fmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType(element_class)) {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new NucleusUserException(LOCALISER.msg("056031", (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = fmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(mappedByFieldName);
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)fmd.getFullFieldName(), (Object)mappedByFieldName, (Object)element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                throw new NucleusUserException(LOCALISER.msg("056025", (Object)fmd.getFullFieldName(), (Object)eofmd.getFullFieldName(), (Object)eofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056029", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)fmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056030", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 4);
        if (fmd.getOrderMetaData() != null && !fmd.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(LOCALISER.msg("056041", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.containerTable) {
            this.containerTable = this.ownerMapping.getDatastoreContainer();
        }
    }

    private FKListStoreSpecialization getSpecialization() {
        return (FKListStoreSpecialization)this.specialization;
    }

    public Object set(StateManager sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element, -1);
        Object o = this.get(sm, index);
        return this.getSpecialization().set(sm, index, element, allowDependentField, this, o);
    }

    private boolean updateElementFk(StateManager sm, Object element, Object owner, int index) {
        if (element == null) {
            return false;
        }
        ObjectManager om = sm.getObjectManager();
        return this.getSpecialization().updateElementFk(sm, element, owner, index, om, this);
    }

    public void update(StateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(sm);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (((Object)existing).equals(coll)) {
            return;
        }
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAdd(StateManager sm, int startAt, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(sm) : size;
        boolean shiftingElements = true;
        if (atEnd || startAt == currentListSize) {
            shiftingElements = false;
            startAt = currentListSize;
        }
        boolean elementsNeedPositioning = false;
        int position = startAt;
        Iterator elementIter = c.iterator();
        while (elementIter.hasNext()) {
            boolean inserted;
            if (shiftingElements) {
                position = -1;
            }
            if (!(inserted = this.validateElementForWriting(sm, elementIter.next(), position)) || shiftingElements) {
                elementsNeedPositioning = true;
            }
            if (shiftingElements) continue;
            ++position;
        }
        if (shiftingElements) {
            try {
                int shift = c.size();
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                try {
                    for (int i = currentListSize - 1; i >= startAt; --i) {
                        this.getSpecialization().internalShift(sm, mconn, false, i, shift, true, this);
                    }
                    Object var16_17 = null;
                    mconn.release();
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    mconn.release();
                    throw throwable;
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)e.getMessage()), e.getCause());
            }
        }
        if (shiftingElements || elementsNeedPositioning) {
            for (Object element : c) {
                this.updateElementFk(sm, element, sm.getObject(), startAt);
                ++startAt;
            }
        }
        return true;
    }

    protected boolean internalRemove(StateManager sm, Object element, int size) {
        if (this.indexedList) {
            int index = this.indexOf(sm, element);
            if (index == -1) {
                return false;
            }
            this.removeAt(sm, index, size);
        } else if (this.ownerMapping.isNullable()) {
            ObjectManager om = sm.getObjectManager();
            StateManager elementSM = om.findStateManager(element);
            if (this.relationType == 4 && om.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
                elementSM.replaceField(this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)[0].getAbsoluteFieldNumber(), null, true);
                if (sm.getObjectManager().isFlushing()) {
                    elementSM.flush();
                }
            } else {
                this.updateElementFk(sm, element, null, -1);
            }
        } else {
            sm.getObjectManager().deleteObjectInternal(element);
        }
        return true;
    }

    protected void manageRemovalOfElement(StateManager ownerSM, Object element) {
    }

    protected void removeAt(StateManager sm, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        boolean nullify = false;
        if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056043"));
            nullify = true;
        } else {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056042"));
        }
        this.getSpecialization().removeAt(sm, index, size, nullify, this);
    }

    public void clear(StateManager ownerSM) {
        boolean deleteElements = false;
        ObjectManager om = ownerSM.getObjectManager();
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping == null) {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056036"));
            deleteElements = false;
        } else if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            Iterator elementsIter = this.iterator(ownerSM);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (om.getApiAdapter().isPersistable(element) && om.getApiAdapter().isDeleted(element)) {
                        StateManager objSM = om.findStateManager(element);
                        objSM.flush();
                        continue;
                    }
                    om.deleteObjectInternal(element);
                }
            }
        } else {
            this.getSpecialization().clearWithoutDelete(om, ownerSM, this);
        }
    }

    protected boolean validateElementForWriting(final StateManager sm, Object element, final int index) {
        final Object newOwner = sm.getObject();
        boolean inserted = super.validateElementForWriting(sm, element, new FieldValues(){

            public void fetchFields(StateManager esm) {
                AbstractClassMetaData[] managingCmds;
                boolean isPersistentInterface = FKListStore.this.storeMgr.getOMFContext().getMetaDataManager().isPersistentInterface(FKListStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = isPersistentInterface ? FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.storeMgr.getOMFContext().getMetaDataManager().getImplementationNameForPersistentInterface(FKListStore.this.elementType), FKListStore.this.clr) : FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.elementType, FKListStore.this.clr);
                if (elementTable == null && (managingCmds = FKListStore.this.storeMgr.getClassesManagingTableForClass(FKListStore.this.emd, FKListStore.this.clr)) != null && managingCmds.length > 0) {
                    for (int i = 0; i < managingCmds.length; ++i) {
                        Class tblCls = FKListStore.this.clr.classForName(managingCmds[i].getFullClassName());
                        if (!tblCls.isAssignableFrom(esm.getObject().getClass())) continue;
                        elementTable = FKListStore.this.storeMgr.getDatastoreClass(managingCmds[i].getFullClassName(), FKListStore.this.clr);
                        break;
                    }
                }
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKListStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setAssociatedValue(externalFKMapping, sm.getObject());
                    }
                    if (FKListStore.this.relationDiscriminatorMapping != null) {
                        esm.setAssociatedValue(FKListStore.this.relationDiscriminatorMapping, FKListStore.this.relationDiscriminatorValue);
                    }
                    if (FKListStore.this.orderMapping != null && index >= 0) {
                        if (FKListStore.this.ownerMemberMetaData.getOrderMetaData() != null && FKListStore.this.ownerMemberMetaData.getOrderMetaData().getMappedBy() != null) {
                            Number indexValue = null;
                            indexValue = FKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || FKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)new Long(index) : (Number)new Integer(index);
                            esm.replaceField(FKListStore.this.orderMapping.getMemberMetaData().getAbsoluteFieldNumber(), indexValue, true);
                        } else {
                            esm.setAssociatedValue(FKListStore.this.orderMapping, new Integer(index));
                        }
                    }
                }
                if (FKListStore.this.ownerFieldNumber >= 0 && sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
                    Object currentOwner = esm.provideField(FKListStore.this.ownerFieldNumber);
                    if (currentOwner == null) {
                        NucleusLogger.JDO.info(BaseContainerStore.LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)FKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(esm.getObject())));
                        esm.replaceField(FKListStore.this.ownerFieldNumber, newOwner, true);
                    } else if (currentOwner != newOwner && sm.getReferencedPC() == null) {
                        throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)FKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(esm.getObject()), (Object)StringUtils.toJVMIDString(currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(StateManager sm2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        return inserted;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ScalarExpression ownerExpr;
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        if (stmt.getTableExpression(elementTableAlias) == null) {
            stmt.newTableExpression(filteredElementTable, elementTableAlias);
        }
        DatastoreIdentifier containerRangeVar = listTableAlias;
        if (existsQuery) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
        } else if (parentStmt != stmt) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else if (elementExpr.getLogicSetExpression().getMainTable() == filteredElementTable) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.innerJoin(ownerExpr, ownerSetExpr, stmt.getTableExpression(containerRangeVar), true, true);
        }
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

