/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import org.datanucleus.util.StringUtils;

public class IndexedValue
implements Serializable {
    public static final IndexedValue TRUE = new IndexedValue(1);
    public static final IndexedValue FALSE = new IndexedValue(2);
    public static final IndexedValue UNIQUE = new IndexedValue(3);
    private final int typeId;

    private IndexedValue(int i) {
        this.typeId = i;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexedValue) {
            return ((IndexedValue)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 1: {
                return "true";
            }
            case 2: {
                return "false";
            }
            case 3: {
                return "unique";
            }
        }
        return "";
    }

    public int getType() {
        return this.typeId;
    }

    public static IndexedValue getIndexedValue(String value) {
        if (StringUtils.isWhitespace(value)) {
            return null;
        }
        if (TRUE.toString().equals(value)) {
            return TRUE;
        }
        if (FALSE.toString().equals(value)) {
            return FALSE;
        }
        if (UNIQUE.toString().equals(value)) {
            return UNIQUE;
        }
        return TRUE;
    }
}

