/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Collection;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.transaction.xa.XAException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUnsupportedOptionException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.jdo.JDOReplicationManager;
import org.datanucleus.jdo.exceptions.ClassNotPersistenceCapableException;
import org.datanucleus.jdo.exceptions.NoPersistenceInformationException;
import org.datanucleus.jdo.exceptions.TransactionNotActiveException;
import org.datanucleus.jdo.exceptions.TransactionNotReadableException;
import org.datanucleus.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.exceptions.DatastoreReadOnlyException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class NucleusJDOHelper
extends JDOHelper {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public static void replicate(PersistenceManagerFactory pmf1, PersistenceManagerFactory pmf2, Object ... oids) {
        JDOReplicationManager replicator = new JDOReplicationManager(pmf1, pmf2);
        replicator.replicate(oids);
    }

    public static void replicate(PersistenceManagerFactory pmf1, PersistenceManagerFactory pmf2, Class ... types) {
        JDOReplicationManager replicator = new JDOReplicationManager(pmf1, pmf2);
        replicator.replicate(types);
    }

    public static void replicate(PersistenceManagerFactory pmf1, PersistenceManagerFactory pmf2, String ... classNames) {
        JDOReplicationManager replicator = new JDOReplicationManager(pmf1, pmf2);
        replicator.replicate(classNames);
    }

    public static ClassMetaData getMetaDataForClass(PersistenceManagerFactory pmf, Class cls) {
        if (pmf == null || cls == null) {
            return null;
        }
        if (!(pmf instanceof JDOPersistenceManagerFactory)) {
            return null;
        }
        JDOPersistenceManagerFactory myPMF = (JDOPersistenceManagerFactory)pmf;
        MetaDataManager mdmgr = myPMF.getOMFContext().getMetaDataManager();
        return (ClassMetaData)mdmgr.getMetaDataForClass(cls, myPMF.getOMFContext().getClassLoaderResolver(null));
    }

    public static String[] getClassesWithMetaData(PersistenceManagerFactory pmf) {
        if (pmf == null || !(pmf instanceof JDOPersistenceManagerFactory)) {
            return null;
        }
        JDOPersistenceManagerFactory myPMF = (JDOPersistenceManagerFactory)pmf;
        Collection classes = myPMF.getOMFContext().getMetaDataManager().getClassesWithMetaData();
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getDetachedObjectDirtyFields(Object obj, PersistenceManager pm) {
        if (obj == null) {
            return null;
        }
        if (!NucleusJDOHelper.isDetached((Object)obj)) {
            throw new NucleusUserException(LOCALISER.msg("010008"));
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        ObjectManager thePM = ((JDOPersistenceManager)pm).getObjectManager();
        StateManager sm = StateManagerFactory.newStateManagerForDetached(thePM, pc, NucleusJDOHelper.getObjectId((Object)pc), null);
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)sm);
        sm.retrieveDetachState(sm);
        String[] dirtyFieldNames = sm.getDirtyFieldNames();
        pc.jdoReplaceStateManager(null);
        return dirtyFieldNames;
    }

    public static String[] getDetachedObjectLoadedFields(Object obj, PersistenceManager pm) {
        if (obj == null) {
            return null;
        }
        if (!NucleusJDOHelper.isDetached((Object)obj)) {
            throw new NucleusUserException(LOCALISER.msg("010008"));
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        ObjectManager thePM = ((JDOPersistenceManager)pm).getObjectManager();
        StateManager sm = StateManagerFactory.newStateManagerForDetached(thePM, pc, NucleusJDOHelper.getObjectId((Object)pc), null);
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)sm);
        sm.retrieveDetachState(sm);
        String[] loadedFieldNames = sm.getLoadedFieldNames();
        pc.jdoReplaceStateManager(null);
        return loadedFieldNames;
    }

    public static JDOException getJDOExceptionForNucleusException(NucleusException jpe) {
        if (jpe instanceof ClassNotPersistableException) {
            return new ClassNotPersistenceCapableException(jpe.getMessage(), jpe);
        }
        if (jpe instanceof org.datanucleus.exceptions.NoPersistenceInformationException) {
            return new NoPersistenceInformationException(jpe.getMessage(), jpe);
        }
        if (jpe instanceof org.datanucleus.exceptions.TransactionNotReadableException) {
            return new TransactionNotReadableException(jpe.getMessage(), jpe.getCause());
        }
        if (jpe instanceof org.datanucleus.exceptions.TransactionNotWritableException) {
            return new TransactionNotWritableException(jpe.getMessage(), jpe.getCause());
        }
        if (jpe instanceof org.datanucleus.exceptions.TransactionNotActiveException) {
            return new TransactionNotActiveException(jpe.getMessage(), jpe);
        }
        if (jpe instanceof NucleusUnsupportedOptionException) {
            return new JDOUnsupportedOptionException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof DatastoreReadOnlyException) {
            ClassLoaderResolver clr = ((DatastoreReadOnlyException)jpe).getClassLoaderResolver();
            try {
                Class cls = clr.classForName("javax.jdo.JDOReadOnlyException");
                throw (JDOUserException)((Object)ClassUtils.newInstance(cls, new Class[]{String.class}, new Object[]{jpe.getMessage()}));
            }
            catch (NucleusException ne) {
                throw new JDOUserException(jpe.getMessage());
            }
        }
        if (jpe instanceof NucleusDataStoreException) {
            if (jpe.isFatal()) {
                if (jpe.getFailedObject() != null) {
                    return new JDOFatalDataStoreException(jpe.getMessage(), jpe.getFailedObject());
                }
                if (jpe.getNestedExceptions() != null) {
                    return new JDOFatalDataStoreException(jpe.getMessage(), jpe.getNestedExceptions());
                }
                return new JDOFatalDataStoreException(jpe.getMessage(), (Throwable)jpe);
            }
            if (jpe.getNestedExceptions() != null) {
                if (jpe.getFailedObject() != null) {
                    return new JDODataStoreException(jpe.getMessage(), jpe.getNestedExceptions(), jpe.getFailedObject());
                }
                return new JDODataStoreException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            if (jpe.getFailedObject() != null) {
                NucleusLogger.JDO.info("Exception thrown", jpe);
                return new JDODataStoreException(jpe.getMessage(), jpe.getFailedObject());
            }
            NucleusLogger.JDO.info("Exception thrown", jpe);
            return new JDODataStoreException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof NucleusObjectNotFoundException) {
            if (jpe.getFailedObject() != null) {
                return new JDOObjectNotFoundException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDOObjectNotFoundException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOObjectNotFoundException(jpe.getMessage(), new Throwable[]{jpe});
        }
        if (jpe instanceof NucleusUserException) {
            if (jpe.isFatal()) {
                if (jpe.getNestedExceptions() != null) {
                    if (jpe.getFailedObject() != null) {
                        return new JDOFatalUserException(jpe.getMessage(), jpe.getNestedExceptions(), jpe.getFailedObject());
                    }
                    return new JDOFatalUserException(jpe.getMessage(), jpe.getNestedExceptions());
                }
                if (jpe.getFailedObject() != null) {
                    NucleusLogger.JDO.info("Exception thrown", jpe);
                    return new JDOFatalUserException(jpe.getMessage(), jpe.getFailedObject());
                }
                NucleusLogger.JDO.info("Exception thrown", jpe);
                return new JDOFatalUserException(jpe.getMessage(), (Throwable)jpe);
            }
            if (jpe.getNestedExceptions() != null) {
                if (jpe.getFailedObject() != null) {
                    return new JDOUserException(jpe.getMessage(), jpe.getNestedExceptions(), jpe.getFailedObject());
                }
                return new JDOUserException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            if (jpe.getFailedObject() != null) {
                NucleusLogger.JDO.info("Exception thrown", jpe);
                return new JDOUserException(jpe.getMessage(), jpe.getFailedObject());
            }
            NucleusLogger.JDO.info("Exception thrown", jpe);
            return new JDOUserException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe instanceof NucleusOptimisticException) {
            if (jpe.getFailedObject() != null) {
                return new JDOOptimisticVerificationException(jpe.getMessage(), jpe.getFailedObject());
            }
            if (jpe.getNestedExceptions() != null) {
                return new JDOOptimisticVerificationException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOOptimisticVerificationException(jpe.getMessage(), (Object)jpe);
        }
        if (jpe instanceof HeuristicRollbackException && jpe.getNestedExceptions().length == 1 && jpe.getNestedExceptions()[0].getCause() instanceof SQLException) {
            return new JDODataStoreException(jpe.getMessage(), ((XAException)jpe.getNestedExceptions()[0]).getCause());
        }
        if (jpe.isFatal()) {
            if (jpe.getNestedExceptions() != null) {
                return new JDOFatalInternalException(jpe.getMessage(), jpe.getNestedExceptions());
            }
            return new JDOFatalInternalException(jpe.getMessage(), (Throwable)jpe);
        }
        if (jpe.getNestedExceptions() != null) {
            return new JDOException(jpe.getMessage(), jpe.getNestedExceptions());
        }
        return new JDOException(jpe.getMessage(), (Throwable)jpe);
    }

    public static JDOImplHelper getJDOImplHelper() {
        return (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return JDOImplHelper.getInstance();
                }
                catch (SecurityException e) {
                    throw new JDOFatalUserException(LOCALISER.msg("026000"), (Throwable)e);
                }
            }
        });
    }
}

