/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;
import org.springframework.util.CommonsLogWriter;

public class HessianExporter
extends RemoteExporter
implements InitializingBean {
    public static final String CONTENT_TYPE_HESSIAN = "application/x-hessian";
    private SerializerFactory serializerFactory = new SerializerFactory();
    private Log debugLogger;
    private HessianSkeleton skeleton;

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory != null ? serializerFactory : new SerializerFactory();
    }

    public void setSendCollectionType(boolean sendCollectionType) {
        this.serializerFactory.setSendCollectionType(sendCollectionType);
    }

    public void setDebug(boolean debug) {
        this.debugLogger = debug ? this.logger : null;
    }

    public void afterPropertiesSet() {
        this.prepare();
    }

    public void prepare() {
        this.checkService();
        this.checkServiceInterface();
        this.skeleton = new HessianSkeleton(this.getProxyForService(), this.getServiceInterface());
    }

    public void invoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        Assert.notNull((Object)this.skeleton, (String)"Hessian exporter has not been initialized");
        this.doInvoke(this.skeleton, inputStream, outputStream);
    }

    protected void doInvoke(HessianSkeleton skeleton, InputStream inputStream, OutputStream outputStream) throws Throwable {
        ClassLoader originalClassLoader = this.overrideThreadContextClassLoader();
        try {
            Object out;
            Hessian2Input in;
            int code;
            InputStream isToUse = inputStream;
            OutputStream osToUse = outputStream;
            if (this.debugLogger != null && this.debugLogger.isDebugEnabled()) {
                PrintWriter debugWriter = new PrintWriter((Writer)new CommonsLogWriter(this.debugLogger));
                HessianDebugInputStream dis = new HessianDebugInputStream(inputStream, debugWriter);
                dis.startTop2();
                HessianDebugOutputStream dos = new HessianDebugOutputStream(outputStream, debugWriter);
                dos.startTop2();
                isToUse = dis;
                osToUse = dos;
            }
            if (!isToUse.markSupported()) {
                isToUse = new BufferedInputStream(isToUse);
                isToUse.mark(1);
            }
            if ((code = isToUse.read()) == 72) {
                int major = isToUse.read();
                int minor = isToUse.read();
                if (major != 2) {
                    throw new IOException("Version " + major + "." + minor + " is not understood");
                }
                in = new Hessian2Input(isToUse);
                out = new Hessian2Output(osToUse);
                in.readCall();
            } else if (code == 67) {
                isToUse.reset();
                in = new Hessian2Input(isToUse);
                out = new Hessian2Output(osToUse);
                in.readCall();
            } else if (code == 99) {
                int major = isToUse.read();
                int minor = isToUse.read();
                in = new HessianInput(isToUse);
                out = major >= 2 ? new Hessian2Output(osToUse) : new HessianOutput(osToUse);
            } else {
                throw new IOException("Expected 'H'/'C' (Hessian 2.0) or 'c' (Hessian 1.0) in hessian input at " + code);
            }
            if (this.serializerFactory != null) {
                in.setSerializerFactory(this.serializerFactory);
                out.setSerializerFactory(this.serializerFactory);
            }
            try {
                skeleton.invoke((AbstractHessianInput)in, (AbstractHessianOutput)out);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    isToUse.close();
                }
                catch (IOException iOException) {}
                try {
                    out.close();
                    osToUse.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                isToUse.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
                osToUse.close();
            }
            catch (IOException iOException) {}
        }
        finally {
            this.resetThreadContextClassLoader(originalClassLoader);
        }
    }
}

