/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import java.util.Date;

public final class Expiration {
    private boolean isOffset;
    private long millis;

    public static Expiration onDate(Date expirationTime) {
        return new Expiration(expirationTime.getTime(), false);
    }

    public static Expiration byDeltaMillis(int milliDelay) {
        return new Expiration(milliDelay, true);
    }

    public static Expiration byDeltaSeconds(int secondsDelay) {
        return Expiration.byDeltaMillis(secondsDelay * 1000);
    }

    private Expiration(long millis, boolean isOffset) {
        this.millis = millis;
        this.isOffset = isOffset;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Expiration) {
            return ((Expiration)obj).millis == this.millis && ((Expiration)obj).isOffset == this.isOffset;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.millis;
    }

    public long getMillisecondsValue() {
        if (this.isOffset) {
            return System.currentTimeMillis() + this.millis;
        }
        return this.millis;
    }

    public int getSecondsValue() {
        return (int)(this.getMillisecondsValue() / 1000L);
    }
}

