package com.jispot.web;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.jispot.common.EmailUtils;
import com.jispot.services.ConnectionService;

@Controller("subscribeController")
public class SubscribeController extends JISpotAjaxController {

    protected final Logger log = Logger.getLogger(this.getClass().getName());

    @Autowired
    private ConnectionService connectionService;

    /**
     * Affiche la page de souscription -> home page now
     */
    @RequestMapping(value = "/subscribe.html", method = RequestMethod.GET)
    public String subscribe() {
        log.info("SubscribeController.subscribe GET called!");
        return "index";
    }

    /**
     * Handler de la methode Get pour l'URL /subscribe.html
     * 
     * @param model
     *            Une map des donnees qui sont utilisables dans la vue
     * @return <code>home</code> La page de redirection : /WEB-INF/jsp/home.jsp.
     */
    @RequestMapping(value = "/subscribe.html", method = RequestMethod.POST)
    public void subscribe(
            HttpServletRequest request,
            HttpServletResponse response,
            @RequestParam(value = "email", required = false) final String email,
            @RequestParam(value = "firstname", required = false) final String firstname,
            @RequestParam(value = "lastname", required = false) final String lastname,
            @RequestParam(value = "password", required = false) final String password,
            @RequestParam(value = "confirm", required = false) final String confirm) {

        super.init(request, response);

        log.info("SubscribeController.subscribe POST called !");
        log.info("email = " + email);
        log.info("firstname = " + firstname);
        log.info("lastname = " + lastname);
        log.info("password = " + password);
        log.info("confirm = " + confirm);

        Map<String, String> resultMap = new HashMap<String, String>();
        if (email == null || email.equals("")) {
            resultMap.put("message", "A valid email is required!");
            resultMap.put("result", "KO");
        } 
        else if (firstname == null || "".equals(firstname)) {
            resultMap.put("message", "First name is mandatory!");
            resultMap.put("result", "KO");
        } 
        else if (firstname == null || "".equals(firstname)) {
            resultMap.put("message", "First name is mandatory!");
            resultMap.put("result", "KO");
        } 
        else if (lastname == null || "".equals(lastname)) {
            resultMap.put("message", "Last name is mandatory!");
            resultMap.put("result", "KO");
        } 
        else if (password == null || "".equals(password)) {
            resultMap.put("message", "Password is mandatory!");
            resultMap.put("result", "KO");
        } 
        else if (password != null && password.equals(confirm) == false) {
            resultMap.put("message", "Passwords must match!");
            resultMap.put("result", "KO");
        }
        else {
        	try {
        		connectionService.subscribe(email, firstname, lastname, password);
                resultMap.put("success", "subscribe.subscription.ok");
                // KLOUG : Send an email for confirmation
                EmailUtils.send(email, firstname + lastname, "JISpot - Subscription confirmed", "Welcome to JISpot !!");
            }
            catch (Throwable th) {
                resultMap.put("message", "subscribe.subscription.ko");
                resultMap.put("result", "KO");
            }
        }

        super.sendJsonResult(resultMap);
    }
}