/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.store.appengine.Ints;
import org.datanucleus.store.appengine.Longs;
import org.datanucleus.store.appengine.PrimitiveArrays;
import org.datanucleus.store.appengine.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveUtils {
    public static final Map<String, Class<?>> PRIMITIVE_CLASSNAMES = PrimitiveUtils.buildPrimitiveClassnameMap();
    public static final Map<Class<?>, Utils.Function<Object, List<?>>> PRIMITIVE_ARRAY_TO_LIST_FUNC_MAP = PrimitiveUtils.buildPrimitiveArrayToListFuncMap();
    public static final Map<Class<?>, Utils.Function<Collection<?>, Object>> COLLECTION_TO_PRIMITIVE_ARRAY_FUNC_MAP = PrimitiveUtils.buildListToPrimitiveArrayFuncMap();

    private PrimitiveUtils() {
    }

    private static Map<String, Class<?>> buildPrimitiveClassnameMap() {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE.getName(), Boolean.TYPE);
        map.put(Integer.TYPE.getName(), Integer.TYPE);
        map.put(Long.TYPE.getName(), Long.TYPE);
        map.put(Short.TYPE.getName(), Short.TYPE);
        map.put(Character.TYPE.getName(), Character.TYPE);
        map.put(Byte.TYPE.getName(), Byte.TYPE);
        map.put(Double.TYPE.getName(), Double.TYPE);
        map.put(Float.TYPE.getName(), Float.TYPE);
        return map;
    }

    private static Map<Class<?>, Utils.Function<Object, List<?>>> buildPrimitiveArrayToListFuncMap() {
        HashMap map = new HashMap();
        map.put(Integer.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return Ints.asList((int[])o);
            }
        });
        map.put(Long.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return Longs.asList((long[])o);
            }
        });
        map.put(Short.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return PrimitiveArrays.asList((short[])o);
            }
        });
        map.put(Byte.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return PrimitiveArrays.asList((byte[])o);
            }
        });
        map.put(Float.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return PrimitiveArrays.asList((float[])o);
            }
        });
        map.put(Double.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return PrimitiveArrays.asList((double[])o);
            }
        });
        map.put(Boolean.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return PrimitiveArrays.asList((boolean[])o);
            }
        });
        map.put(Character.TYPE, new Utils.Function<Object, List<?>>(){

            @Override
            public List<?> apply(Object o) {
                return PrimitiveArrays.asList((char[])o);
            }
        });
        return map;
    }

    private static Map<Class<?>, Utils.Function<Collection<?>, Object>> buildListToPrimitiveArrayFuncMap() {
        HashMap map = new HashMap();
        map.put(Integer.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return Ints.toArray((List)list);
            }
        });
        map.put(Short.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return PrimitiveArrays.toShortArray(list);
            }
        });
        map.put(Long.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return Longs.toArray(list);
            }
        });
        map.put(Character.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return PrimitiveArrays.toCharArray(list);
            }
        });
        map.put(Float.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return PrimitiveArrays.toFloatArray(list);
            }
        });
        map.put(Double.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return PrimitiveArrays.toDoubleArray(list);
            }
        });
        map.put(Boolean.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return PrimitiveArrays.toBooleanArray(list);
            }
        });
        map.put(Byte.TYPE, new Utils.Function<Collection<?>, Object>(){

            @Override
            public Object apply(Collection<?> list) {
                return PrimitiveArrays.toByteArray(list);
            }
        });
        return map;
    }
}

