/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.utils.HttpRequestParser;
import com.google.appengine.api.xmpp.JID;
import com.google.appengine.api.xmpp.Presence;
import com.google.appengine.api.xmpp.PresenceBuilder;
import com.google.appengine.api.xmpp.PresenceShow;
import com.google.appengine.api.xmpp.PresenceType;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;

class InboundPresenceParser
extends HttpRequestParser {
    InboundPresenceParser() {
    }

    static Presence parsePresence(HttpServletRequest request) throws IOException {
        try {
            MimeMultipart multipart = InboundPresenceParser.parseMultipartRequest(request);
            PresenceBuilder builder = new PresenceBuilder();
            if (request.getRequestURI().endsWith("/presence/available/")) {
                builder.withPresenceType(PresenceType.AVAILABLE).withPresenceShow(PresenceShow.NONE);
            } else if (request.getRequestURI().endsWith("/presence/unavailable/")) {
                builder.withPresenceType(PresenceType.UNAVAILABLE);
            } else if (request.getRequestURI().endsWith("/presence/probe/")) {
                builder.withPresenceType(PresenceType.PROBE);
            } else {
                throw new IllegalArgumentException("Can't determine the type of stanza from the path: " + request.getRequestURI());
            }
            int parts = multipart.getCount();
            for (int i = 0; i < parts; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String fieldName = InboundPresenceParser.getFieldName(part);
                if ("from".equals(fieldName)) {
                    builder.withFromJid(new JID(InboundPresenceParser.getTextContent(part)));
                    continue;
                }
                if ("to".equals(fieldName)) {
                    builder.withToJid(new JID(InboundPresenceParser.getTextContent(part)));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    builder.withStatus(InboundPresenceParser.getTextContent(part));
                    continue;
                }
                if ("show".equals(fieldName)) {
                    builder.withPresenceShow(PresenceShow.valueOf(InboundPresenceParser.getTextContent(part).toUpperCase()));
                    continue;
                }
                if (!"stanza".equals(fieldName)) continue;
                builder.withStanza(InboundPresenceParser.getTextContent(part));
            }
            return builder.build();
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Could not parse incoming request.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

