/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.collection.AbstractCollectionCondition;

public class MaxSizeCollectionCondition
extends AbstractCollectionCondition {
    private int maxSize;

    public MaxSizeCollectionCondition(int maxSize) {
        Assert.isTrue((maxSize >= 0 ? 1 : 0) != 0, (String)"Max size cannot be negative");
        this.maxSize = maxSize;
    }

    protected boolean checkArray(Object array) {
        return Array.getLength(array) <= this.maxSize;
    }

    protected boolean checkCollection(Collection collection) {
        return collection.size() <= this.maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

