/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.appengine.InsertMappingConsumer;
import org.datanucleus.store.appengine.KeyRegistry;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;

class DatastoreRelationFieldManager {
    private static final int[] NOT_USED = new int[]{0};
    static final int IS_PARENT_VALUE = -1;
    private static final int[] IS_PARENT_VALUE_ARR = new int[]{-1};
    static final String PARENT_KEY_PROPERTY = "____PARENT_KEY____";
    public static final int IS_FK_VALUE = -2;
    private static final int[] IS_FK_VALUE_ARR = new int[]{-2};
    private final DatastoreFieldManager fieldManager;
    private final List<StoreRelationEvent> storeRelationEvents = Utils.newArrayList(new Object[0]);

    DatastoreRelationFieldManager(DatastoreFieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean storeRelations(KeyRegistry keyRegistry) {
        if (this.storeRelationEvents.isEmpty()) {
            return false;
        }
        if (this.fieldManager.getEntity().getKey() != null) {
            keyRegistry.registerKey(this.getStateManager(), this.fieldManager);
        }
        for (StoreRelationEvent event : this.storeRelationEvents) {
            event.apply();
        }
        this.storeRelationEvents.clear();
        try {
            boolean bl = keyRegistry.parentNeedsUpdate(this.fieldManager.getEntity().getKey());
            return bl;
        }
        finally {
            keyRegistry.clearModifiedParent(this.fieldManager.getEntity().getKey());
        }
    }

    private DatastoreManager getStoreManager() {
        return this.fieldManager.getStoreManager();
    }

    void storeRelationField(final AbstractClassMetaData acmd, final AbstractMemberMetaData ammd, final Object value, final boolean isInsert, final InsertMappingConsumer consumer) {
        StoreRelationEvent event = new StoreRelationEvent(){

            public void apply() {
                DatastoreTable table = DatastoreRelationFieldManager.this.fieldManager.getDatastoreTable();
                StateManager sm = DatastoreRelationFieldManager.this.getStateManager();
                int fieldNumber = ammd.getAbsoluteFieldNumber();
                try {
                    JavaTypeMapping mapping = table.getMemberMappingInDatastoreClass(ammd);
                    if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping || mapping instanceof PersistenceCapableMapping || mapping instanceof InterfaceMapping) {
                        this.setObjectViaMapping(mapping, table, value, sm, fieldNumber);
                        sm.wrapSCOField(fieldNumber, value, false, true, true);
                    } else if (isInsert) {
                        DatastoreRelationFieldManager.this.runPostInsertMappingCallbacks(consumer, value);
                    } else {
                        DatastoreRelationFieldManager.this.runPostUpdateMappingCallbacks(consumer);
                    }
                }
                catch (NotYetFlushedException e) {
                    if (acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getNullValue() == NullValue.EXCEPTION) {
                        throw e;
                    }
                    sm.updateFieldAfterInsert(e.getPersistable(), fieldNumber);
                }
            }

            private void setObjectViaMapping(JavaTypeMapping mapping, DatastoreTable table, Object value2, StateManager sm, int fieldNumber) {
                boolean fieldIsParentKeyProvider = table.isParentKeyProvider(ammd);
                if (!fieldIsParentKeyProvider) {
                    DatastoreRelationFieldManager.checkForParentSwitch(value2, sm);
                }
                Entity entity = DatastoreRelationFieldManager.this.fieldManager.getEntity();
                mapping.setObject(DatastoreRelationFieldManager.this.fieldManager.getObjectManager(), (Object)entity, fieldIsParentKeyProvider ? IS_PARENT_VALUE_ARR : IS_FK_VALUE_ARR, value2, sm, fieldNumber);
                Object parentKeyObj = entity.getProperty(DatastoreRelationFieldManager.PARENT_KEY_PROPERTY);
                if (parentKeyObj != null) {
                    AbstractClassMetaData parentCmd = sm.getMetaDataManager().getMetaDataForClass(ammd.getType(), DatastoreRelationFieldManager.this.fieldManager.getClassLoaderResolver());
                    Key parentKey = EntityUtils.getPkAsKey(parentKeyObj, parentCmd, DatastoreRelationFieldManager.this.fieldManager.getObjectManager());
                    entity.removeProperty(DatastoreRelationFieldManager.PARENT_KEY_PROPERTY);
                    DatastoreRelationFieldManager.this.fieldManager.recreateEntityWithParent(parentKey);
                }
            }
        };
        this.storeRelationEvents.add(event);
    }

    static void checkForParentSwitch(Object child, StateManager parentSM) {
        if (child == null) {
            return;
        }
        ObjectManager om = parentSM.getObjectManager();
        ApiAdapter apiAdapter = om.getApiAdapter();
        StateManager childStateMgr = om.findStateManager(child);
        if (apiAdapter.isNew(child) && (childStateMgr == null || childStateMgr.getAssociatedValue((Object)EntityUtils.getCurrentTransaction(om)) == null)) {
            return;
        }
        Object childKeyOrString = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(child));
        if (childKeyOrString == null) {
            return;
        }
        Key childKey = childKeyOrString instanceof Key ? (Key)childKeyOrString : KeyFactory.stringToKey((String)((String)childKeyOrString));
        Key parentKey = EntityUtils.getPrimaryKeyAsKey(apiAdapter, parentSM);
        if (childKey.getParent() == null) {
            throw new ChildWithoutParentException(parentKey, childKey);
        }
        if (!parentKey.equals((Object)childKey.getParent())) {
            throw new ChildWithWrongParentException(parentKey, childKey);
        }
    }

    private void runPostInsertMappingCallbacks(InsertMappingConsumer consumer, Object value) {
        StateManager sm = this.getStateManager();
        for (MappingCallbacks callback : consumer.getMappingCallbacks()) {
            callback.postInsert(sm);
        }
    }

    private void runPostUpdateMappingCallbacks(InsertMappingConsumer consumer) {
        StateManager sm = this.getStateManager();
        for (MappingCallbacks callback : consumer.getMappingCallbacks()) {
            callback.postUpdate(sm);
        }
    }

    Object fetchRelationField(ClassLoaderResolver clr, AbstractMemberMetaData ammd) {
        Object value;
        DatastoreTable dt = this.fieldManager.getDatastoreTable();
        JavaTypeMapping mapping = dt.getMemberMappingInDatastoreClass(ammd);
        if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping) {
            value = mapping.getObject(this.fieldManager.getObjectManager(), (Object)this.fieldManager.getEntity(), NOT_USED, this.getStateManager(), ammd.getAbsoluteFieldNumber());
        } else {
            int relationType = ammd.getRelationType(clr);
            if (relationType == 2 || relationType == 1) {
                DatastoreTable table = this.fieldManager.getDatastoreTable();
                value = table.isParentKeyProvider(ammd) ? this.lookupParent(ammd, mapping, false) : this.lookupOneToOneChild(ammd, clr);
            } else if (relationType == 6) {
                MetaData parent;
                MetaData other = ammd.getRelatedMemberMetaData(clr)[0].getParent();
                boolean allowNullParent = other == (parent = ammd.getParent()) && this.fieldManager.getEntity().getKey().getParent() == null;
                value = this.lookupParent(ammd, mapping, allowNullParent);
            } else {
                value = null;
            }
        }
        return this.getStateManager().wrapSCOField(ammd.getAbsoluteFieldNumber(), value, false, false, false);
    }

    private Object lookupParent(AbstractMemberMetaData ammd, JavaTypeMapping mapping, boolean allowNullParent) {
        Key parentKey = this.fieldManager.getEntity().getParent();
        if (parentKey == null) {
            if (!allowNullParent) {
                String childClass = this.fieldManager.getStateManager().getClassMetaData().getFullClassName();
                throw new FatalNucleusUserException("Field " + ammd.getFullFieldName() + " should be able to " + "provide a reference to its parent but the entity does not have a parent.  " + "Did you perhaps try to establish an instance of " + childClass + " as " + "the child of an instance of " + ammd.getTypeName() + " after the child had already been " + "persisted?");
            }
            return null;
        }
        ObjectManager om = this.getStateManager().getObjectManager();
        return mapping.getObject(om, (Object)parentKey, NOT_USED);
    }

    private Object lookupOneToOneChild(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        ObjectManager om = this.getStateManager().getObjectManager();
        AbstractClassMetaData childClassMetaData = om.getMetaDataManager().getMetaDataForClass(ammd.getType(), clr);
        String kind = this.getStoreManager().getIdentifierFactory().newDatastoreContainerIdentifier(childClassMetaData).getIdentifierName();
        Entity parentEntity = this.fieldManager.getEntity();
        Query q = new Query(kind, parentEntity.getKey());
        DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
        DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService(config);
        for (Entity e : datastoreService.prepare(q).asIterable()) {
            if (!parentEntity.getKey().equals((Object)e.getKey().getParent())) continue;
            return DatastoreQuery.entityToPojo(e, childClassMetaData, clr, om, false, om.getFetchPlan());
        }
        return null;
    }

    private StateManager getStateManager() {
        return this.fieldManager.getStateManager();
    }

    static class ChildWithWrongParentException
    extends FatalNucleusUserException {
        public ChildWithWrongParentException(Key parentKey, Key childKey) {
            super("Detected attempt to establish " + parentKey + " as the " + "parent of " + childKey + " but the entity identified by " + childKey + " is already a child of " + childKey.getParent() + ".  A parent cannot " + "be established or changed once an object has been persisted.");
        }
    }

    static class ChildWithoutParentException
    extends FatalNucleusUserException {
        public ChildWithoutParentException(Key parentKey, Key childKey) {
            super("Detected attempt to establish " + parentKey + " as the " + "parent of " + childKey + " but the entity identified by " + childKey + " has already been persisted without a parent.  A parent cannot " + "be established or changed once an object has been persisted.");
        }
    }

    private static interface StoreRelationEvent {
        public void apply();
    }
}

