/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javax.persistence.spi.ClassTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassFileTransformerAdapter
implements ClassFileTransformer {
    private static final Log logger = LogFactory.getLog(ClassFileTransformerAdapter.class);
    private final ClassTransformer classTransformer;

    public ClassFileTransformerAdapter(ClassTransformer classTransformer) {
        Assert.notNull((Object)classTransformer, (String)"ClassTransformer must not be null");
        this.classTransformer = classTransformer;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            byte[] transformed = this.classTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            if (transformed != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Transformer of class [" + this.classTransformer.getClass().getName() + "] transformed class [" + className + "]; bytes in=" + classfileBuffer.length + "; bytes out=" + transformed.length));
            }
            return transformed;
        }
        catch (ClassCircularityError ex) {
            logger.error((Object)("Error weaving class [" + className + "] with " + "transformer of class [" + this.classTransformer.getClass().getName() + "]"), (Throwable)ex);
            throw new IllegalStateException("Could not weave class [" + className + "]", ex);
        }
        catch (Throwable ex) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Error weaving class [" + className + "] with " + "transformer of class [" + this.classTransformer.getClass().getName() + "]"), ex);
            }
            throw new IllegalStateException("Could not weave class [" + className + "]", ex);
        }
    }

    public String toString() {
        return "Standard ClassFileTransformer wrapping JPA transformer: " + this.classTransformer;
    }
}

