/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.converter;

import java.io.Serializable;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.MessageCodesResolver;

public class ModelAwareMessageCodesResolver
implements MessageCodesResolver,
Serializable {
    private MessageCodesResolver internalResolver;

    public ModelAwareMessageCodesResolver() {
        this((MessageCodesResolver)new DefaultMessageCodesResolver());
    }

    public ModelAwareMessageCodesResolver(MessageCodesResolver internalResolver) {
        this.internalResolver = internalResolver;
    }

    public String[] resolveMessageCodes(String errorCode, String objectName) {
        int prefixIndex = errorCode.lastIndexOf("[");
        int suffixIndex = errorCode.lastIndexOf("]");
        if (prefixIndex < 0 || suffixIndex < 0 || suffixIndex != errorCode.length() - 1) {
            return this.internalResolver.resolveMessageCodes(errorCode, objectName);
        }
        String basicCode = errorCode.substring(prefixIndex + 1, suffixIndex);
        String[] basicCodes = this.internalResolver.resolveMessageCodes(basicCode, objectName);
        String[] codes = new String[basicCodes.length + 1];
        System.arraycopy(basicCodes, 0, codes, 1, basicCodes.length);
        codes[0] = errorCode;
        return codes;
    }

    public String[] resolveMessageCodes(String errorCode, String objectName, String field, Class fieldType) {
        int prefixIndex = errorCode.lastIndexOf("[");
        int suffixIndex = errorCode.lastIndexOf("]");
        if (prefixIndex < 0 || suffixIndex < 0 || suffixIndex != errorCode.length() - 1) {
            return this.internalResolver.resolveMessageCodes(errorCode, objectName, field, fieldType);
        }
        String basicCode = errorCode.substring(prefixIndex + 1, suffixIndex);
        String[] basicCodes = this.internalResolver.resolveMessageCodes(basicCode, objectName, field, fieldType);
        String[] codes = new String[basicCodes.length + 1];
        System.arraycopy(basicCodes, 0, codes, 1, basicCodes.length);
        codes[0] = errorCode;
        return codes;
    }
}

