/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.utils.HttpRequestParser;
import com.google.appengine.api.xmpp.JID;
import com.google.appengine.api.xmpp.Message;
import com.google.appengine.api.xmpp.MessageBuilder;
import com.google.appengine.api.xmpp.MessageType;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;

class InboundMessageParser
extends HttpRequestParser {
    InboundMessageParser() {
    }

    static Message parseMessage(HttpServletRequest request) throws IOException {
        try {
            MimeMultipart multipart = InboundMessageParser.parseMultipartRequest(request);
            MessageBuilder builder = new MessageBuilder();
            builder.withMessageType(MessageType.CHAT);
            int parts = multipart.getCount();
            for (int i = 0; i < parts; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String fieldName = InboundMessageParser.getFieldName(part);
                if ("from".equals(fieldName)) {
                    builder.withFromJid(new JID(InboundMessageParser.getTextContent(part)));
                    continue;
                }
                if ("to".equals(fieldName)) {
                    builder.withRecipientJids(new JID(InboundMessageParser.getTextContent(part)));
                    continue;
                }
                if ("body".equals(fieldName)) {
                    builder.withBody(InboundMessageParser.getTextContent(part));
                    continue;
                }
                if (!"stanza".equals(fieldName)) continue;
                builder.withStanza(InboundMessageParser.getTextContent(part));
            }
            return builder.build();
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Could not parse incoming request.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

