/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.xmpp.JID;
import com.google.appengine.api.xmpp.PresenceShow;
import com.google.appengine.api.xmpp.PresenceType;

public final class Presence {
    private final boolean isAvailable;
    private final PresenceType presenceType;
    private final PresenceShow presenceShow;
    private final String status;
    private final JID fromJid;
    private final JID toJid;
    private final String stanza;

    Presence(boolean isAvailable, JID toJid, JID fromJid) {
        this.isAvailable = isAvailable;
        this.presenceType = PresenceType.AVAILABLE;
        this.presenceShow = null;
        this.fromJid = fromJid;
        this.toJid = toJid;
        this.stanza = null;
        this.status = null;
    }

    Presence(PresenceType type, PresenceShow show, String status, JID toJid, JID fromJid, String stanza) {
        this.presenceType = type;
        this.isAvailable = type != PresenceType.UNAVAILABLE;
        this.presenceShow = show;
        this.status = status;
        this.toJid = toJid;
        this.fromJid = fromJid;
        this.stanza = stanza;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public PresenceType getPresenceType() {
        return this.presenceType;
    }

    public PresenceShow getPresenceShow() {
        return this.presenceShow;
    }

    public String getStatus() {
        return this.status;
    }

    public JID getFromJid() {
        return this.fromJid;
    }

    public JID getToJid() {
        return this.toJid;
    }

    public String getStanza() {
        return this.stanza;
    }
}

