/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.remoting.httpinvoker.AbstractHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.StringUtils;

public class CommonsHttpInvokerRequestExecutor
extends AbstractHttpInvokerRequestExecutor {
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private HttpClient httpClient;

    public CommonsHttpInvokerRequestExecutor() {
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.setReadTimeout(60000);
    }

    public CommonsHttpInvokerRequestExecutor(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
    }

    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        PostMethod postMethod = this.createPostMethod(config);
        try {
            this.setRequestBody(config, postMethod, baos);
            this.executePostMethod(config, this.getHttpClient(), postMethod);
            this.validateResponse(config, postMethod);
            InputStream responseBody = this.getResponseBody(config, postMethod);
            RemoteInvocationResult remoteInvocationResult = this.readRemoteInvocationResult(responseBody, config.getCodebaseUrl());
            return remoteInvocationResult;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    protected PostMethod createPostMethod(HttpInvokerClientConfiguration config) throws IOException {
        PostMethod postMethod = new PostMethod(config.getServiceUrl());
        LocaleContext locale = LocaleContextHolder.getLocaleContext();
        if (locale != null) {
            postMethod.addRequestHeader("Accept-Language", StringUtils.toLanguageTag((Locale)locale.getLocale()));
        }
        if (this.isAcceptGzipEncoding()) {
            postMethod.addRequestHeader("Accept-Encoding", "gzip");
        }
        return postMethod;
    }

    protected void setRequestBody(HttpInvokerClientConfiguration config, PostMethod postMethod, ByteArrayOutputStream baos) throws IOException {
        postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(baos.toByteArray(), this.getContentType()));
    }

    protected void executePostMethod(HttpInvokerClientConfiguration config, HttpClient httpClient, PostMethod postMethod) throws IOException {
        httpClient.executeMethod((HttpMethod)postMethod);
    }

    protected void validateResponse(HttpInvokerClientConfiguration config, PostMethod postMethod) throws IOException {
        if (postMethod.getStatusCode() >= 300) {
            throw new HttpException("Did not receive successful HTTP response: status code = " + postMethod.getStatusCode() + ", status message = [" + postMethod.getStatusText() + "]");
        }
    }

    protected InputStream getResponseBody(HttpInvokerClientConfiguration config, PostMethod postMethod) throws IOException {
        if (this.isGzipResponse(postMethod)) {
            return new GZIPInputStream(postMethod.getResponseBodyAsStream());
        }
        return postMethod.getResponseBodyAsStream();
    }

    protected boolean isGzipResponse(PostMethod postMethod) {
        Header encodingHeader = postMethod.getResponseHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.getValue() != null && encodingHeader.getValue().toLowerCase().indexOf("gzip") != -1;
    }
}

