/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.converter;

import org.springframework.util.ClassUtils;
import org.springmodules.validation.bean.converter.ErrorCodeConverter;

public class ModelAwareErrorCodeConverter
implements ErrorCodeConverter {
    static final String ERROR_CODE_SEPERATOR_PREFIX = "[";
    static final String ERROR_CODE_SEPERATOR_SUFFIX = "]";
    static final String PROPERTY_SEPERATOR = ".";
    private boolean useFullyQualifiedClassName;

    public ModelAwareErrorCodeConverter() {
        this(false);
    }

    public ModelAwareErrorCodeConverter(boolean useFullyQualifiedClassName) {
        this.useFullyQualifiedClassName = useFullyQualifiedClassName;
    }

    public String convertGlobalErrorCode(String errorCode, Class clazz) {
        String className = this.useFullyQualifiedClassName ? clazz.getName() : ClassUtils.getShortName((Class)clazz);
        return className + ERROR_CODE_SEPERATOR_PREFIX + errorCode + ERROR_CODE_SEPERATOR_SUFFIX;
    }

    public String convertPropertyErrorCode(String errorCode, Class clazz, String propertyName) {
        String className = this.useFullyQualifiedClassName ? clazz.getName() : ClassUtils.getShortName((Class)clazz);
        return className + PROPERTY_SEPERATOR + propertyName + ERROR_CODE_SEPERATOR_PREFIX + errorCode + ERROR_CODE_SEPERATOR_SUFFIX;
    }

    public void setUseFullyQualifiedClassName(boolean useFullyQualifiedClassName) {
        this.useFullyQualifiedClassName = useFullyQualifiedClassName;
    }
}

