/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.WeakFastHashMap;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CalendarConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.ConverterFacade;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FileConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.beanutils.converters.URLConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtilsBean {
    private static final Integer ZERO = new Integer(0);
    private static final Character SPACE = new Character(' ');
    private WeakFastHashMap converters = new WeakFastHashMap();
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$ConvertUtils == null ? (class$org$apache$commons$beanutils$ConvertUtils = ConvertUtilsBean.class$("org.apache.commons.beanutils.ConvertUtils")) : class$org$apache$commons$beanutils$ConvertUtils));
    private Boolean defaultBoolean = Boolean.FALSE;
    private Byte defaultByte = new Byte(0);
    private Character defaultCharacter = new Character(' ');
    private Double defaultDouble = new Double(0.0);
    private Float defaultFloat = new Float(0.0f);
    private Integer defaultInteger = new Integer(0);
    private Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);
    static /* synthetic */ Class class$org$apache$commons$beanutils$ConvertUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class array$Ljava$lang$String;

    protected static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean newDefaultBoolean) {
        this.defaultBoolean = newDefaultBoolean ? Boolean.TRUE : Boolean.FALSE;
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        this.register(new BooleanConverter(this.defaultBoolean), class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtilsBean.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte newDefaultByte) {
        this.defaultByte = new Byte(newDefaultByte);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        this.register(new ByteConverter(this.defaultByte), class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char newDefaultCharacter) {
        this.defaultCharacter = new Character(newDefaultCharacter);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        this.register(new CharacterConverter(this.defaultCharacter), class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtilsBean.class$("java.lang.Character")) : class$java$lang$Character);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double newDefaultDouble) {
        this.defaultDouble = new Double(newDefaultDouble);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        this.register(new DoubleConverter(this.defaultDouble), class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float newDefaultFloat) {
        this.defaultFloat = new Float(newDefaultFloat);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        this.register(new FloatConverter(this.defaultFloat), class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int newDefaultInteger) {
        this.defaultInteger = new Integer(newDefaultInteger);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        this.register(new IntegerConverter(this.defaultInteger), class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long newDefaultLong) {
        this.defaultLong = new Long(newDefaultLong);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        this.register(new LongConverter(this.defaultLong), class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short newDefaultShort) {
        defaultShort = new Short(newDefaultShort);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        this.register(new ShortConverter(defaultShort), class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short);
    }

    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) < 1) {
                return null;
            }
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            Converter converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
            return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, value);
        }
        Converter converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
        return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, value);
    }

    public Object convert(String value, Class clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert string '" + value + "' to class '" + clazz.getName() + "'"));
        }
        if ((converter = this.lookup(clazz)) == null) {
            converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        return converter.convert(clazz, value);
    }

    public Object convert(String[] values, Class clazz) {
        Converter converter;
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert String[" + values.length + "] to class '" + type.getName() + "[]'"));
        }
        if ((converter = this.lookup(type)) == null) {
            converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        Object array = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, converter.convert(type, values[i]));
        }
        return array;
    }

    public Object convert(Object value, Class targetType) {
        Class<?> sourceType;
        Class<?> clazz = sourceType = value == null ? null : value.getClass();
        if (this.log.isDebugEnabled()) {
            if (value == null) {
                this.log.debug((Object)("Convert null value to type '" + targetType.getName() + "'"));
            } else {
                this.log.debug((Object)("Convert type '" + sourceType.getName() + "' value '" + value + "' to type '" + targetType.getName() + "'"));
            }
        }
        Object converted = value;
        Converter converter = this.lookup(sourceType, targetType);
        if (converter != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("  Using converter " + converter));
            }
            converted = converter.convert(targetType, value);
        }
        if (targetType == (class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String) && converted != null && !(converted instanceof String)) {
            converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
            if (converter != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("  Using converter " + converter));
                }
                converted = converter.convert(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, converted);
            }
            if (converted != null && !(converted instanceof String)) {
                converted = converted.toString();
            }
        }
        return converted;
    }

    public void deregister() {
        this.converters.clear();
        this.registerPrimitives(false);
        this.registerStandard(false, false);
        this.registerOther(true);
        this.registerArrays(false, 0);
        this.register(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConvertUtilsBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalConverter());
        this.register(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConvertUtilsBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerConverter());
    }

    public void register(boolean throwException, boolean defaultNull, int defaultArraySize) {
        this.registerPrimitives(throwException);
        this.registerStandard(throwException, defaultNull);
        this.registerOther(throwException);
        this.registerArrays(throwException, defaultArraySize);
    }

    private void registerPrimitives(boolean throwException) {
        this.register(Boolean.TYPE, throwException ? new BooleanConverter() : new BooleanConverter(Boolean.FALSE));
        this.register(Byte.TYPE, throwException ? new ByteConverter() : new ByteConverter(ZERO));
        this.register(Character.TYPE, throwException ? new CharacterConverter() : new CharacterConverter(SPACE));
        this.register(Double.TYPE, throwException ? new DoubleConverter() : new DoubleConverter(ZERO));
        this.register(Float.TYPE, throwException ? new FloatConverter() : new FloatConverter(ZERO));
        this.register(Integer.TYPE, throwException ? new IntegerConverter() : new IntegerConverter(ZERO));
        this.register(Long.TYPE, throwException ? new LongConverter() : new LongConverter(ZERO));
        this.register(Short.TYPE, throwException ? new ShortConverter() : new ShortConverter(ZERO));
    }

    private void registerStandard(boolean throwException, boolean defaultNull) {
        Integer defaultNumber = defaultNull ? null : ZERO;
        BigDecimal bigDecDeflt = defaultNull ? null : new BigDecimal("0.0");
        BigInteger bigIntDeflt = defaultNull ? null : new BigInteger("0");
        Boolean booleanDefault = defaultNull ? null : Boolean.FALSE;
        Character charDefault = defaultNull ? null : SPACE;
        String stringDefault = defaultNull ? null : "";
        this.register(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConvertUtilsBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, throwException ? new BigDecimalConverter() : new BigDecimalConverter(bigDecDeflt));
        this.register(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConvertUtilsBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, throwException ? new BigIntegerConverter() : new BigIntegerConverter(bigIntDeflt));
        this.register(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtilsBean.class$("java.lang.Boolean")) : class$java$lang$Boolean, throwException ? new BooleanConverter() : new BooleanConverter(booleanDefault));
        this.register(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte, throwException ? new ByteConverter() : new ByteConverter(defaultNumber));
        this.register(class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtilsBean.class$("java.lang.Character")) : class$java$lang$Character, throwException ? new CharacterConverter() : new CharacterConverter(charDefault));
        this.register(class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double, throwException ? new DoubleConverter() : new DoubleConverter(defaultNumber));
        this.register(class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float, throwException ? new FloatConverter() : new FloatConverter(defaultNumber));
        this.register(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer, throwException ? new IntegerConverter() : new IntegerConverter(defaultNumber));
        this.register(class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long, throwException ? new LongConverter() : new LongConverter(defaultNumber));
        this.register(class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short, throwException ? new ShortConverter() : new ShortConverter(defaultNumber));
        this.register(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, throwException ? new StringConverter() : new StringConverter(stringDefault));
    }

    private void registerOther(boolean throwException) {
        this.register(class$java$lang$Class == null ? (class$java$lang$Class = ConvertUtilsBean.class$("java.lang.Class")) : class$java$lang$Class, throwException ? new ClassConverter() : new ClassConverter(null));
        this.register(class$java$util$Date == null ? (class$java$util$Date = ConvertUtilsBean.class$("java.util.Date")) : class$java$util$Date, throwException ? new DateConverter() : new DateConverter(null));
        this.register(class$java$util$Calendar == null ? (class$java$util$Calendar = ConvertUtilsBean.class$("java.util.Calendar")) : class$java$util$Calendar, throwException ? new CalendarConverter() : new CalendarConverter(null));
        this.register(class$java$io$File == null ? (class$java$io$File = ConvertUtilsBean.class$("java.io.File")) : class$java$io$File, throwException ? new FileConverter() : new FileConverter(null));
        this.register(class$java$sql$Date == null ? (class$java$sql$Date = ConvertUtilsBean.class$("java.sql.Date")) : class$java$sql$Date, throwException ? new SqlDateConverter() : new SqlDateConverter(null));
        this.register(class$java$sql$Time == null ? (class$java$sql$Time = ConvertUtilsBean.class$("java.sql.Time")) : class$java$sql$Time, throwException ? new SqlTimeConverter() : new SqlTimeConverter(null));
        this.register(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConvertUtilsBean.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, throwException ? new SqlTimestampConverter() : new SqlTimestampConverter(null));
        this.register(class$java$net$URL == null ? (class$java$net$URL = ConvertUtilsBean.class$("java.net.URL")) : class$java$net$URL, throwException ? new URLConverter() : new URLConverter(null));
    }

    private void registerArrays(boolean throwException, int defaultArraySize) {
        this.registerArrayConverter(Boolean.TYPE, new BooleanConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Byte.TYPE, new ByteConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Character.TYPE, new CharacterConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Double.TYPE, new DoubleConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Float.TYPE, new FloatConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Integer.TYPE, new IntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Long.TYPE, new LongConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(Short.TYPE, new ShortConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConvertUtilsBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConvertUtilsBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtilsBean.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte, new ByteConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtilsBean.class$("java.lang.Character")) : class$java$lang$Character, new CharacterConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double, new DoubleConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float, new FloatConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long, new LongConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short, new ShortConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, new StringConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$lang$Class == null ? (class$java$lang$Class = ConvertUtilsBean.class$("java.lang.Class")) : class$java$lang$Class, new ClassConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$util$Date == null ? (class$java$util$Date = ConvertUtilsBean.class$("java.util.Date")) : class$java$util$Date, new DateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$util$Calendar == null ? (class$java$util$Calendar = ConvertUtilsBean.class$("java.util.Calendar")) : class$java$util$Calendar, new DateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$io$File == null ? (class$java$io$File = ConvertUtilsBean.class$("java.io.File")) : class$java$io$File, new FileConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$sql$Date == null ? (class$java$sql$Date = ConvertUtilsBean.class$("java.sql.Date")) : class$java$sql$Date, new SqlDateConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$sql$Time == null ? (class$java$sql$Time = ConvertUtilsBean.class$("java.sql.Time")) : class$java$sql$Time, new SqlTimeConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConvertUtilsBean.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new SqlTimestampConverter(), throwException, defaultArraySize);
        this.registerArrayConverter(class$java$net$URL == null ? (class$java$net$URL = ConvertUtilsBean.class$("java.net.URL")) : class$java$net$URL, new URLConverter(), throwException, defaultArraySize);
    }

    private void registerArrayConverter(Class componentType, Converter componentConverter, boolean throwException, int defaultArraySize) {
        Class<?> arrayType = Array.newInstance(componentType, 0).getClass();
        ArrayConverter arrayConverter = null;
        arrayConverter = throwException ? new ArrayConverter(arrayType, componentConverter) : new ArrayConverter(arrayType, componentConverter, defaultArraySize);
        this.register(arrayType, arrayConverter);
    }

    private void register(Class clazz, Converter converter) {
        this.register(new ConverterFacade(converter), clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public Converter lookup(Class sourceType, Class targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Target type is missing");
        }
        if (sourceType == null) {
            return this.lookup(targetType);
        }
        Converter converter = null;
        if (targetType == (class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String)) {
            converter = this.lookup(sourceType);
            if (converter == null && (sourceType.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = ConvertUtilsBean.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(sourceType))) {
                converter = this.lookup(array$Ljava$lang$String == null ? (array$Ljava$lang$String = ConvertUtilsBean.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            }
            if (converter == null) {
                converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
            }
            return converter;
        }
        if (targetType == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = ConvertUtilsBean.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            if (sourceType.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = ConvertUtilsBean.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(sourceType)) {
                converter = this.lookup(sourceType);
            }
            if (converter == null) {
                converter = this.lookup(array$Ljava$lang$String == null ? (array$Ljava$lang$String = ConvertUtilsBean.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            }
            return converter;
        }
        return this.lookup(targetType);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

