/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.sco.SCOMtoN;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.scostore.AbstractSetStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class JoinSetStore
extends AbstractSetStore {
    public JoinSetStore(AbstractMemberMetaData mmd, DatastoreContainerObject joinTable, ClassLoaderResolver clr, JavaTypeMapping ownerMapping, JavaTypeMapping elementMapping, JavaTypeMapping orderMapping, JavaTypeMapping relationDiscriminatorMapping, String relationDiscriminatorValue, boolean isEmbeddedElement, boolean isSerialisedElement, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)joinTable.getStoreManager(), clr, specialization);
        this.containerTable = joinTable;
        this.setOwner(mmd, clr);
        this.ownerMapping = ownerMapping;
        this.elementMapping = elementMapping;
        this.orderMapping = orderMapping;
        this.relationDiscriminatorMapping = relationDiscriminatorMapping;
        this.relationDiscriminatorValue = relationDiscriminatorValue;
        this.elementType = mmd.getCollection().getElementType();
        this.elementsAreEmbedded = isEmbeddedElement;
        this.elementsAreSerialised = isSerialisedElement;
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType(element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null && !this.elementsAreEmbedded ? this.getElementInformationForClass() : null;
            }
        }
    }

    public void update(StateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(sm);
            this.addAll(sm, coll, 0);
            return;
        }
        Iterator elemIter = this.iterator(sm);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(sm, elem, 0);
            }
        }
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = this.removeAllInternal(sm, elements, size);
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    protected abstract boolean removeAllInternal(StateManager var1, Collection var2, int var3);

    private boolean elementAlreadyContainsOwnerInMtoN(StateManager ownerSM, Object element) {
        AbstractMemberMetaData[] relatedMmds;
        ObjectManager om = ownerSM.getObjectManager();
        StateManager elementSM = om.findStateManager(element);
        Object elementSCO = elementSM.provideField((relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(om.getClassLoaderResolver()))[0].getAbsoluteFieldNumber());
        if (elementSCO instanceof SCOMtoN) {
            if (this.contains(ownerSM, element)) {
                NucleusLogger.DATASTORE.info(LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
                return true;
            }
        } else if (this.locate(ownerSM, element)) {
            NucleusLogger.DATASTORE.info(LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            return true;
        }
        return false;
    }

    public abstract boolean locate(StateManager var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int size) {
        StateManager elementSM;
        this.validateElementForWriting(sm, element, null);
        if (this.relationType == 4 && sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && (elementSM = sm.getObjectManager().findStateManager(element)) != null) {
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.JDO.info(LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
            } else if (elementOwner != sm.getObject() && sm.getReferencedPC() == null) {
                throw new NucleusUserException(LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject()), (Object)StringUtils.toJVMIDString(elementOwner)));
            }
        }
        boolean modified = false;
        boolean toBeInserted = true;
        if (this.relationType == 5) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                try {
                    int[] returnCode;
                    int orderID = -1;
                    if (this.orderMapping != null) {
                        orderID = this.getNextIDForOrderColumn(sm);
                    }
                    if ((returnCode = this.internalAdd(sm, element, mconn, false, orderID, true))[0] > 0) {
                        modified = true;
                    }
                    Object var11_14 = null;
                    mconn.release();
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    mconn.release();
                    throw throwable;
                }
            }
            catch (MappedDatastoreException e) {
                NucleusLogger.DATASTORE.error(e);
                String msg = LOCALISER.msg("056009", (Object)e.getMessage());
                NucleusLogger.DATASTORE.error(msg);
                throw new NucleusDataStoreException(msg, e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = elements.size() > 1;
        for (Object element : elements) {
            StateManager elementSM;
            this.validateElementForWriting(sm, element, null);
            if (this.relationType != 4 || !sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") || (elementSM = sm.getObjectManager().findStateManager(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.JDO.info(LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
                continue;
            }
            if (elementOwner == sm.getObject() || sm.getReferencedPC() != null) continue;
            throw new NucleusUserException(LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject()), (Object)StringUtils.toJVMIDString(elementOwner)));
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                this.preGetNextIDForOrderColumn(mconn);
                int nextOrderID = 0;
                if (this.orderMapping != null) {
                    nextOrderID = this.getNextIDForOrderColumn(sm);
                }
                Iterator iter = elements.iterator();
                Object element = null;
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.internalAdd(sm, element, mconn, batched, nextOrderID, !batched || batched && !iter.hasNext());
                        if (rc != null) {
                            for (int i = 0; i < rc.length; ++i) {
                                if (rc[i] <= 0) continue;
                                modified = true;
                            }
                        }
                        ++nextOrderID;
                    }
                    catch (MappedDatastoreException mde) {
                        mde.printStackTrace();
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error(mde);
                    }
                }
                Object var15_17 = null;
                mconn.release();
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                mconn.release();
                throw throwable;
            }
        }
        catch (MappedDatastoreException e) {
            e.printStackTrace();
            exceptions.add(e);
            NucleusLogger.DATASTORE.error(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)((Exception)exceptions.get(0)).getMessage());
            NucleusLogger.DATASTORE.error(msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    protected abstract void preGetNextIDForOrderColumn(ManagedConnection var1) throws MappedDatastoreException;

    private int[] internalAdd(StateManager sm, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        boolean toBeInserted = true;
        if (this.relationType == 5) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            return this.doInternalAdd(sm, element, conn, batched, orderId, executeNow);
        }
        return null;
    }

    protected abstract int[] doInternalAdd(StateManager var1, Object var2, ManagedConnection var3, boolean var4, int var5, boolean var6) throws MappedDatastoreException;

    protected abstract int getNextIDForOrderColumn(StateManager var1) throws MappedDatastoreException;

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTblExpr, DatastoreIdentifier setTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        if (!existsQuery) {
            LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, setTableAlias);
            if (!parentStmt.hasCrossJoin(ownTblExpr) && !stmt.getMainTableExpression().equals(ownTblExpr)) {
                stmt.crossJoin(ownTblExpr, true);
            }
            ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTblExpr);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        }
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        DatastoreClass joiningClass = elementExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elementExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementTableAlias);
        if (elmTblExpr == null) {
            if (!(elementExpr instanceof UnboundVariable) && parentStmt != stmt) {
                elmTblExpr = parentStmt.getTableExpression(elementTableAlias);
            }
            if (elmTblExpr == null) {
                elmTblExpr = stmt.newTableExpression(elementTable, elementTableAlias);
            }
        }
        if (!parentStmt.getMainTableExpression().equals(elmTblExpr) && !parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
        if (elementExpr.getLogicSetExpression() != null && !elementTable.equals(elementExpr.getLogicSetExpression().getMainTable())) {
            if (existsQuery) {
                stmt.andCondition(elmSetExpr.eq(elementExpr), true);
                return elmSetExpr;
            }
            return elmSetExpr;
        }
        if (existsQuery) {
            ScalarExpression elementIdExpr = elementTableID.newScalarExpression(stmt, elmTblExpr);
            stmt.andCondition(elmSetExpr.eq(elementIdExpr), true);
            return elementIdExpr;
        }
        return elmSetExpr;
    }
}

