package com.jispot.services.impl;

import java.util.logging.Logger;

import org.springframework.stereotype.Service;

import com.jispot.common.StringUtils;
import com.jispot.domain.model.Apikey;
import com.jispot.services.ApikeyService;

@Service("apikeyService")
public class ApikeyServiceImpl implements ApikeyService {

	protected final Logger log = Logger.getLogger(this.getClass().getName());

	public Apikey get( Long id ) {
		return Apikey.all().filter("id", id).get();
	}

	public String getKey( Long id ) {
		Apikey obj = Apikey.all().filter("id", id).get();
		return obj != null ? obj.key : null;
	}

	public boolean isValid( Long id ) {
		Apikey obj = Apikey.all().filter("id", id).get();
		return obj != null ? obj.valid : false;
	}

	public boolean isValid( String key ) {
		Apikey obj = Apikey.all().filter("key", key).get();
		return obj != null ? obj.valid : false;
	}

	public boolean exists(String key) {
		Apikey obj = Apikey.all().filter("key", key).get();
		return ( obj !=null && obj.id != null );
	}

	public void create() {
		create(false);
	}

	public void create(final boolean valid) {

		String generatedApiKey = StringUtils.getRandomText( 64 );

		Apikey obj = new Apikey();
		obj.key = generatedApiKey;
		obj.valid = valid;
		obj.insert();
	}

}
