/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import org.springframework.jdbc.datasource.embedded.DerbyEmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.embedded.H2EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.HsqlEmbeddedDatabaseConfigurer;
import org.springframework.util.Assert;

final class EmbeddedDatabaseConfigurerFactory {
    public static EmbeddedDatabaseConfigurer getConfigurer(EmbeddedDatabaseType type) throws IllegalStateException {
        Assert.notNull((Object)((Object)type), (String)"EmbeddedDatabaseType is required");
        try {
            switch (type) {
                case HSQL: {
                    return HsqlEmbeddedDatabaseConfigurer.getInstance();
                }
                case H2: {
                    return H2EmbeddedDatabaseConfigurer.getInstance();
                }
                case DERBY: {
                    return DerbyEmbeddedDatabaseConfigurer.getInstance();
                }
            }
            throw new UnsupportedOperationException("Other embedded database types not yet supported");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Driver for test database type [" + (Object)((Object)type) + "] is not available in the classpath", ex);
        }
    }

    private EmbeddedDatabaseConfigurerFactory() {
    }
}

