/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.work.jboss;

import java.lang.reflect.Method;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.spi.work.WorkManager;

public abstract class JBossWorkManagerUtils {
    private static final String JBOSS_WORK_MANAGER_MBEAN_CLASS_NAME = "org.jboss.resource.work.JBossWorkManagerMBean";
    private static final String MBEAN_SERVER_CONNECTION_JNDI_NAME = "jmx/invoker/RMIAdaptor";
    private static final String WORK_MANAGER_OBJECT_NAME = "jboss.jca:service=WorkManager";

    public static WorkManager getWorkManager() {
        try {
            Class<?> mbeanClass = JBossWorkManagerUtils.class.getClassLoader().loadClass(JBOSS_WORK_MANAGER_MBEAN_CLASS_NAME);
            InitialContext jndiContext = new InitialContext();
            MBeanServerConnection mconn = (MBeanServerConnection)jndiContext.lookup(MBEAN_SERVER_CONNECTION_JNDI_NAME);
            ObjectName objectName = ObjectName.getInstance(WORK_MANAGER_OBJECT_NAME);
            Object workManagerMBean = MBeanServerInvocationHandler.newProxyInstance(mconn, objectName, mbeanClass, false);
            Method getInstanceMethod = workManagerMBean.getClass().getMethod("getInstance", new Class[0]);
            return (WorkManager)getInstanceMethod.invoke(workManagerMBean, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize JBossWorkManagerTaskExecutor because JBoss API is not available: " + ex);
        }
    }
}

