/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.GenericCollectionTypeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetFactoryBean
extends AbstractFactoryBean<Set> {
    private Set sourceSet;
    private Class targetSetClass;

    public void setSourceSet(Set sourceSet) {
        this.sourceSet = sourceSet;
    }

    public void setTargetSetClass(Class targetSetClass) {
        if (targetSetClass == null) {
            throw new IllegalArgumentException("'targetSetClass' must not be null");
        }
        if (!Set.class.isAssignableFrom(targetSetClass)) {
            throw new IllegalArgumentException("'targetSetClass' must implement [java.util.Set]");
        }
        this.targetSetClass = targetSetClass;
    }

    @Override
    public Class<Set> getObjectType() {
        return Set.class;
    }

    @Override
    protected Set createInstance() {
        if (this.sourceSet == null) {
            throw new IllegalArgumentException("'sourceSet' is required");
        }
        LinkedHashSet result = null;
        result = this.targetSetClass != null ? (LinkedHashSet)BeanUtils.instantiateClass(this.targetSetClass) : new LinkedHashSet(this.sourceSet.size());
        Class valueType = null;
        if (this.targetSetClass != null) {
            valueType = GenericCollectionTypeResolver.getCollectionType((Class)this.targetSetClass);
        }
        if (valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            for (Object elem : this.sourceSet) {
                result.add(converter.convertIfNecessary(elem, valueType));
            }
        } else {
            result.addAll(this.sourceSet);
        }
        return result;
    }
}

