package com.jispot.web.spot;

import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.jispot.web.JISpotAjaxController;

@Controller("homeSpotController")
public class HomeSpotController extends JISpotAjaxController {

    protected final Logger log = Logger.getLogger(this.getClass().getName());

    /**
     * Handler de la methode Get pour l'URL /index.html.
     *
     * @param model Une map des donnees qui sont utilisables dans la vue
     * @return <code>home</code> La page de redirection : /WEB-INF/jsp/home.jsp.
     */
    @RequestMapping(value="/jispot/index.html", method = RequestMethod.GET)
    public String index(final ModelMap model, HttpServletRequest request) {
        super.init(request, response);
        log.info("HomeSpotController.index called!");

        if ( getUserId() == null ) {
            model.addAttribute("message", "acess.forbidden");
            return "forward:"+ request.getContextPath() +"/index.html";
        }
        String lat = "47.234156";
        String lng = "5.742995";
        model.addAttribute("lat", lat);
        model.addAttribute("lng", lng);
        return "jispot/index";
    }    

}
