/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@Beta
public final class CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long createCount;
    private final long totalCreateTime;
    private final long evictionCount;

    public CacheStats(long hitCount, long missCount, long createCount, long totalCreateTime, long evictionCount) {
        Preconditions.checkArgument(hitCount >= 0L);
        Preconditions.checkArgument(missCount >= 0L);
        Preconditions.checkArgument(createCount >= 0L);
        Preconditions.checkArgument(totalCreateTime >= 0L);
        Preconditions.checkArgument(evictionCount >= 0L);
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.createCount = createCount;
        this.totalCreateTime = totalCreateTime;
        this.evictionCount = evictionCount;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public long createCount() {
        return this.createCount;
    }

    public long totalCreateTime() {
        return this.totalCreateTime;
    }

    public double averageCreatePenalty() {
        return this.createCount == 0L ? 0.0 : (double)this.totalCreateTime / (double)this.createCount;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public CacheStats minus(CacheStats other) {
        return new CacheStats(this.hitCount - other.hitCount, this.missCount - other.missCount, this.createCount - other.createCount, this.totalCreateTime - other.totalCreateTime, this.evictionCount - other.evictionCount);
    }

    public int hashCode() {
        return Objects.hashCode(this.hitCount, this.missCount, this.createCount, this.totalCreateTime, this.evictionCount);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof CacheStats) {
            CacheStats other = (CacheStats)object;
            return this.hitCount == other.hitCount && this.missCount == other.missCount && this.createCount == other.createCount && this.totalCreateTime == other.totalCreateTime && this.evictionCount == other.evictionCount;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("hitCount", this.hitCount).add("missCount", this.missCount).add("createCount", this.createCount).add("totalCreateTime", this.totalCreateTime).add("evictionCount", this.evictionCount).toString();
    }
}

