/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;

public class MessageContext {
    private final Part part;

    public MessageContext(Part part) {
        this.part = part;
    }

    public Part getPart() {
        return this.part;
    }

    public Message getMessage() {
        return this.getMessageFrom(this.part);
    }

    public Session getSession() {
        Message message = this.getMessage();
        if (message == null) {
            return null;
        }
        return message.session;
    }

    private Message getMessageFrom(Part p) {
        while (p != null) {
            if (p instanceof Message) {
                return (Message)p;
            }
            Multipart mp = ((BodyPart)p).getParent();
            if (mp == null) {
                return null;
            }
            p = mp.getParent();
        }
        return null;
    }
}

