/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.jpa.EntityManagerFactoryImpl;
import org.datanucleus.jpa.JPAAdapter;
import org.datanucleus.jpa.exceptions.NoPersistenceUnitException;
import org.datanucleus.jpa.exceptions.NoPersistenceXmlException;
import org.datanucleus.jpa.exceptions.NotProviderException;

public class PersistenceProviderImpl
implements PersistenceProvider {
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo unitInfo, Map properties) {
        try {
            EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl(unitInfo, properties);
            return emf;
        }
        catch (NotProviderException npe) {
            return null;
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String unitName, Map properties) {
        try {
            EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl(unitName, properties);
            return emf;
        }
        catch (NotProviderException npe) {
            return null;
        }
        catch (NoPersistenceUnitException npue) {
            return null;
        }
        catch (NoPersistenceXmlException npxe) {
            return null;
        }
    }

    public LoadState isLoadedWithoutReference(Object entity, String memberName) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        JPAAdapter adapter = new JPAAdapter();
        ObjectManager om = adapter.getObjectManager(entity);
        if (om == null) {
            return LoadState.UNKNOWN;
        }
        StateManager sm = om.findStateManager(entity);
        if (sm == null) {
            return LoadState.UNKNOWN;
        }
        String[] loadedFields = sm.getLoadedFieldNames();
        if (loadedFields != null) {
            for (int i = 0; i < loadedFields.length; ++i) {
                if (!loadedFields[i].equals(memberName)) continue;
                return LoadState.LOADED;
            }
        }
        return LoadState.NOT_LOADED;
    }

    public LoadState isLoadedWithReference(Object entity, String memberName) {
        return this.isLoadedWithoutReference(entity, memberName);
    }

    public LoadState isLoaded(Object entity) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        return null;
    }
}

