/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.Serializable;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.identity.OID;
import org.datanucleus.util.Localiser;

public class OIDImpl
implements Serializable,
OID,
Comparable {
    protected static final transient Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private static final transient String oidSeparator = "[OID]";
    public final Object oid;
    public final String pcClass;
    public final String toString;
    public final int hashCode;

    public OIDImpl() {
        this.oid = null;
        this.pcClass = null;
        this.toString = null;
        this.hashCode = -1;
    }

    public OIDImpl(String pcClass, Object object) {
        this.pcClass = pcClass;
        this.oid = object;
        StringBuffer s = new StringBuffer();
        s.append(this.oid.toString());
        s.append(oidSeparator);
        s.append(this.pcClass);
        this.toString = s.toString();
        this.hashCode = this.toString.hashCode();
    }

    public OIDImpl(String str) throws IllegalArgumentException {
        if (str.length() < 2) {
            throw new IllegalArgumentException(LOCALISER.msg("038000", (Object)str));
        }
        if (str.indexOf(oidSeparator) < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("038000", (Object)str));
        }
        int start = 0;
        int end = str.indexOf(oidSeparator, start);
        String oidStr = str.substring(start, end);
        Object oidValue = null;
        try {
            oidValue = new Long(oidStr);
        }
        catch (NumberFormatException nfe) {
            oidValue = oidStr;
        }
        this.oid = oidValue;
        start = end + oidSeparator.length();
        this.pcClass = str.substring(start, str.length());
        this.toString = str;
        this.hashCode = this.toString.hashCode();
    }

    public Object getKeyValue() {
        return this.oid;
    }

    public String getPcClass() {
        return this.pcClass;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().getName().equals(ClassNameConstants.OIDImpl)) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return ((Object)((OID)obj)).toString().equals(this.toString);
    }

    public int compareTo(Object o) {
        if (o instanceof OIDImpl) {
            OIDImpl c = (OIDImpl)o;
            return this.toString.compareTo(c.toString);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }
}

